/********** EngineeringInstrumentTelemGroup.h *************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_INSTRUMENT_TELEM_GROUP_

  #define _MOPITT_L1_ENGINEERING_INSTRUMENT_TELEM_GROUP_

  #include "EngineeringDataGroup.h"
  #include "EngineeringDataConstants.h"

  class engineering_instrument_telem_group : public engineering_data_group {
    private :
      static int const DIODE_1_HIGH_REFERENCE_OFFSET;
      static int const DIODE_1_LOW_REFERENCE_OFFSET;
      static int const DIODE_2_HIGH_REFERENCE_OFFSET;
      static int const DIODE_2_LOW_REFERENCE_OFFSET;
      static int const THERMISTOR_1_HIGH_REFERENCE_OFFSET;
      static int const THERMISTOR_1_LOW_REFERENCE_OFFSET;
      static int const THERMISTOR_2_HIGH_REFERENCE_OFFSET;
      static int const THERMISTOR_2_LOW_REFERENCE_OFFSET;
      static int const THERMISTOR_3_HIGH_REFERENCE_OFFSET;
      static int const THERMISTOR_3_LOW_REFERENCE_OFFSET;
      static int const THERMISTOR_4_HIGH_REFERENCE_OFFSET;
      static int const THERMISTOR_4_LOW_REFERENCE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_instrument_telem_sensor { DIODE_1_HIGH_REFERENCE,       DIODE_1_LOW_REFERENCE, 
                                                 DIODE_2_HIGH_REFERENCE,       DIODE_2_LOW_REFERENCE,
                                                 THERMISTOR_1_HIGH_REFERENCE,  THERMISTOR_1_LOW_REFERENCE,
                                                 THERMISTOR_2_HIGH_REFERENCE,  THERMISTOR_2_LOW_REFERENCE,
                                                 THERMISTOR_3_HIGH_REFERENCE,  THERMISTOR_3_LOW_REFERENCE,
                                                 THERMISTOR_4_HIGH_REFERENCE,  THERMISTOR_4_LOW_REFERENCE };

    protected :

    public :
      engineering_instrument_telem_group ();
      ~engineering_instrument_telem_group ();

      void AddBlock      (unsigned char*);
      bool Define        (int32, int32, string const&, string const&);
      void GetReferences (int, int, float [DIODE_BANKS] [ENGINEERING_STATES], float [DIODE_BANKS] [ENGINEERING_STATES],
                          float [THERMISTOR_BANKS] [ENGINEERING_STATES], float [THERMISTOR_BANKS] [ENGINEERING_STATES]);
  };

#endif
