/********** EngineeringInstrumentTelemGroup.C *************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringInstrumentTelemGroup.h"

int const engineering_instrument_telem_group::DIODE_1_HIGH_REFERENCE_OFFSET      = 84;
int const engineering_instrument_telem_group::DIODE_1_LOW_REFERENCE_OFFSET       = 86;
int const engineering_instrument_telem_group::DIODE_2_HIGH_REFERENCE_OFFSET      = 160;
int const engineering_instrument_telem_group::DIODE_2_LOW_REFERENCE_OFFSET       = 162;
int const engineering_instrument_telem_group::THERMISTOR_1_HIGH_REFERENCE_OFFSET = 112;
int const engineering_instrument_telem_group::THERMISTOR_1_LOW_REFERENCE_OFFSET  = 114;
int const engineering_instrument_telem_group::THERMISTOR_2_HIGH_REFERENCE_OFFSET = 116;
int const engineering_instrument_telem_group::THERMISTOR_2_LOW_REFERENCE_OFFSET  = 118;
int const engineering_instrument_telem_group::THERMISTOR_3_HIGH_REFERENCE_OFFSET = 120;
int const engineering_instrument_telem_group::THERMISTOR_3_LOW_REFERENCE_OFFSET  = 122;
int const engineering_instrument_telem_group::THERMISTOR_4_HIGH_REFERENCE_OFFSET = 124;
int const engineering_instrument_telem_group::THERMISTOR_4_LOW_REFERENCE_OFFSET  = 126;
int const engineering_instrument_telem_group::FIELDCOUNT                         = 12;

engineering_instrument_telem_group :: engineering_instrument_telem_group ()
                                    : engineering_data_group ()
{
  ;
}


engineering_instrument_telem_group :: ~engineering_instrument_telem_group ()
{
  ;
}


void engineering_instrument_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [DIODE_1_HIGH_REFERENCE]      = UnpackData (&blockdata [DIODE_1_HIGH_REFERENCE_OFFSET]);
  telemdata [DIODE_1_LOW_REFERENCE]       = UnpackData (&blockdata [DIODE_1_LOW_REFERENCE_OFFSET]);
  telemdata [DIODE_2_HIGH_REFERENCE]      = UnpackData (&blockdata [DIODE_2_HIGH_REFERENCE_OFFSET]);
  telemdata [DIODE_2_LOW_REFERENCE]       = UnpackData (&blockdata [DIODE_2_LOW_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_1_HIGH_REFERENCE] = UnpackData (&blockdata [THERMISTOR_1_HIGH_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_1_LOW_REFERENCE]  = UnpackData (&blockdata [THERMISTOR_1_LOW_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_2_HIGH_REFERENCE] = UnpackData (&blockdata [THERMISTOR_2_HIGH_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_2_LOW_REFERENCE]  = UnpackData (&blockdata [THERMISTOR_2_LOW_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_3_HIGH_REFERENCE] = UnpackData (&blockdata [THERMISTOR_3_HIGH_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_3_LOW_REFERENCE]  = UnpackData (&blockdata [THERMISTOR_3_LOW_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_4_HIGH_REFERENCE] = UnpackData (&blockdata [THERMISTOR_4_HIGH_REFERENCE_OFFSET]);
  telemdata [THERMISTOR_4_LOW_REFERENCE]  = UnpackData (&blockdata [THERMISTOR_4_LOW_REFERENCE_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_instrument_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                   string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Diode Bank 1 High Reference", "Diode Bank 1 Low Reference",
                                          "Diode Bank 2 High Reference", "Diode Bank 2 Low Reference",
                                          "Thermistor Bank 1 High Reference", "Thermistor Bank 1 Low Reference",
                                          "Thermistor Bank 2 High Reference", "Thermistor Bank 2 Low Reference",
                                          "Thermistor Bank 3 High Reference", "Thermistor Bank 3 Low Reference",
                                          "Thermistor Bank 4 High Reference", "Thermistor Bank 4 Low Reference"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Instrument Telem Group", groupclass,
                                         "Engineering Instrument Telem Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_instrument_telem_group :: GetReferences (int startindex, int stopindex, 
                                                          float diodehighrefs [DIODE_BANKS] [ENGINEERING_STATES],
                                                          float diodelowrefs [DIODE_BANKS] [ENGINEERING_STATES], 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES])
{
  datalist.GetAverageValue ((int) DIODE_1_HIGH_REFERENCE,      startindex, stopindex, diodehighrefs[0]);
  datalist.GetAverageValue ((int) DIODE_2_HIGH_REFERENCE,      startindex, stopindex, diodehighrefs[1]);
  datalist.GetAverageValue ((int) DIODE_1_LOW_REFERENCE,       startindex, stopindex, diodelowrefs[0]);
  datalist.GetAverageValue ((int) DIODE_2_LOW_REFERENCE,       startindex, stopindex, diodelowrefs[1]);
  datalist.GetAverageValue ((int) THERMISTOR_1_HIGH_REFERENCE, startindex, stopindex, thermistorhighrefs[0]);
  datalist.GetAverageValue ((int) THERMISTOR_2_HIGH_REFERENCE, startindex, stopindex, thermistorhighrefs[1]);
  datalist.GetAverageValue ((int) THERMISTOR_3_HIGH_REFERENCE, startindex, stopindex, thermistorhighrefs[2]);
  datalist.GetAverageValue ((int) THERMISTOR_4_HIGH_REFERENCE, startindex, stopindex, thermistorhighrefs[3]);
  datalist.GetAverageValue ((int) THERMISTOR_1_LOW_REFERENCE,  startindex, stopindex, thermistorlowrefs[0]);
  datalist.GetAverageValue ((int) THERMISTOR_2_LOW_REFERENCE,  startindex, stopindex, thermistorlowrefs[1]);
  datalist.GetAverageValue ((int) THERMISTOR_3_LOW_REFERENCE,  startindex, stopindex, thermistorlowrefs[2]);
  datalist.GetAverageValue ((int) THERMISTOR_4_LOW_REFERENCE,  startindex, stopindex, thermistorlowrefs[3]);
}
