/********** EngineeringInstrumentData.h *******************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_INSTRUMENT_DATA_

  #define _MOPITT_L1_ENGINEERING_INSTRUMENT_DATA_

  #include "EngineeringDataConstants.h"
  #include "EngineeringBlock.h"
  #include "EngineeringInstrumentTelemGroup.h"
  #include "EngineeringInstrumentBlock3Group.h"
  #include "EngineeringInstrumentBlock5Group.h"
  #include "EngineeringInstrumentBlock8Group.h"

  class engineering_instrument_data {
    private :
      engineering_instrument_telem_group  telemgroup;
      engineering_instrument_block3_group block3group;
      engineering_instrument_block5_group block5group;
      engineering_instrument_block8_group block8group;
      hdf_vgroup                          vgroup;

    protected :

    public :
      engineering_instrument_data ();
      ~engineering_instrument_data ();

      void AddBlock             (engineering_block*);
      bool Close                ();
      bool Define               (int32, int32, string const&);
      void GetReferences        (int, int, float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [DIODE_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES]);
      void GetBlock3SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock5SummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock8SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      bool Write                ();
  };

#endif
