/********** EngineeringInstrumentData.C *******************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringInstrumentData.h"

engineering_instrument_data :: engineering_instrument_data ()
                             : telemgroup ()
                             , block3group ()
                             , block5group ()
                             , block8group ()
                             , vgroup ()
{
  ;
}


engineering_instrument_data :: ~engineering_instrument_data ()
{
  ;
}


void engineering_instrument_data :: AddBlock (engineering_block* engineeringblock)
{
  // add the data to the telem group
  unsigned char* telemdata = engineeringblock->GetTelemData ();
  telemgroup.AddBlock (telemdata);

  // if necessary, add the block data to the appropriate group
  unsigned char* blockdata;
  switch (engineeringblock->GetBlockNumber ()) {
    case 3 : blockdata = engineeringblock->GetHouseData ();
             block3group.AddBlock (blockdata);
             break;
    case 5 : blockdata = engineeringblock->GetHouseData ();
             block5group.AddBlock (blockdata);
             break;
    case 8 : blockdata = engineeringblock->GetHouseData ();
             block8group.AddBlock (blockdata);
             break;
    default : break;
  }
}


bool engineering_instrument_data :: Close ()
{
  bool isclosed = false;

  if (telemgroup.Close ())
    if (block3group.Close ())
      if (block5group.Close ())
        if (block8group.Close ())
          if (vgroup.Close ())
            isclosed = true;

  return isclosed;
}


bool engineering_instrument_data :: Define (int32 fileid, int32 engineeringid, string const& maingroupclass) 
{
  bool isdefined = false;
  string const groupclass = "Engineering Instrument Group";
  string const dataclass  = "Engineering Instrument Data";

  if (vgroup.Create (groupclass, maingroupclass, fileid))
    if (telemgroup.Define (fileid, vgroup.GetID (), groupclass, dataclass))
      if (block3group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
        if (block5group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
          if (block8group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
            if (vgroup.Insert (engineeringid))
              isdefined = true;

  return isdefined;
}


void engineering_instrument_data :: GetReferences (int startindex, int stopindex, 
                                                   float diodehighrefs [DIODE_BANKS][ENGINEERING_STATES], 
                                                   float diodelowrefs [DIODE_BANKS][ENGINEERING_STATES], 
                                                   float thermistorhighrefs [THERMISTOR_BANKS][ENGINEERING_STATES], 
                                                   float thermistorlowrefs [THERMISTOR_BANKS][ENGINEERING_STATES])
{
  telemgroup.GetReferences (startindex, stopindex, diodehighrefs, diodelowrefs, thermistorhighrefs, thermistorlowrefs);
}


void engineering_instrument_data :: GetBlock3SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block3group.GetSummaryData (startindex, stopindex, mopipfile, summaryengineering);
}


void engineering_instrument_data :: GetBlock5SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block5group.GetSummaryData (startindex, stopindex, mopipfile, thermistorhighrefs, thermistorlowrefs, 
                              summaryengineering);
}


void engineering_instrument_data :: GetBlock8SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block8group.GetSummaryData (startindex, stopindex, mopipfile, summaryengineering);
}


bool engineering_instrument_data :: Write ()
{
  bool iswritten = false;

  if (telemgroup.Write  ())
    if (block3group.Write ())
      if (block5group.Write ())
        if (block8group.Write ())
          iswritten = true;

  return iswritten;
}
