/********** EngineeringInstrumentBlock8Group.h ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK8_GROUP_

  #define _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK8_GROUP_

  #include "EngineeringDataGroup.h"
  #include "EngineeringDataConstants.h"
  #include "MOPIPFile.h"

  class engineering_instrument_block8_group : public engineering_data_group {
    private :
      static int const SPACE_PORT_BAFFEL_TEMPERATURE_OFFSET;
      static int const EARTH_PORT_BAFFEL_TEMPERATURE_OFFSET;
      static int const PCDM_HIGH_REFERENCE_OFFSET;
      static int const PCDM_LOW_REFERENCE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_instrument_block8_sensor {SPACE_PORT_BAFFEL_TEMPERATURE, EARTH_PORT_BAFFEL_TEMPERATURE,
                                                 PCDM_HIGH_REFERENCE,           PCDM_LOW_REFERENCE};

    protected :

    public :
      engineering_instrument_block8_group ();
      ~engineering_instrument_block8_group ();

      void AddBlock       (unsigned char*);
      bool Define         (int32, int32, string const&, string const&);
      void GetSummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
  };

#endif
