/********** EngineeringInstrumentBlock8Group.C ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringInstrumentBlock8Group.h"

int const engineering_instrument_block8_group::SPACE_PORT_BAFFEL_TEMPERATURE_OFFSET = 54;
int const engineering_instrument_block8_group::EARTH_PORT_BAFFEL_TEMPERATURE_OFFSET = 38;
int const engineering_instrument_block8_group::PCDM_HIGH_REFERENCE_OFFSET           = 56;
int const engineering_instrument_block8_group::PCDM_LOW_REFERENCE_OFFSET            = 58;
int const engineering_instrument_block8_group::FIELDCOUNT                           = 4;

engineering_instrument_block8_group :: engineering_instrument_block8_group ()
                                     : engineering_data_group ()
{
  ;
}


engineering_instrument_block8_group :: ~engineering_instrument_block8_group ()
{
  ;
}


void engineering_instrument_block8_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [SPACE_PORT_BAFFEL_TEMPERATURE] = UnpackData (&blockdata [SPACE_PORT_BAFFEL_TEMPERATURE_OFFSET]);
  housedata [EARTH_PORT_BAFFEL_TEMPERATURE] = UnpackData (&blockdata [EARTH_PORT_BAFFEL_TEMPERATURE_OFFSET]);
  housedata [PCDM_HIGH_REFERENCE]           = UnpackData (&blockdata [PCDM_HIGH_REFERENCE_OFFSET]);
  housedata [PCDM_LOW_REFERENCE]            = UnpackData (&blockdata [PCDM_LOW_REFERENCE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_instrument_block8_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                    string const& dataclass)
{
  string const  fieldnames [FIELDCOUNT] = {"Space Port Baffel Temperature", "Earth Port Baffel Temperature", 
                                           "PCDM High Reference", "PCDM Low Reference"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Instrument Block8 Group", groupclass,
                                         "Engineering Instrument Block8 Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_instrument_block8_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES], highref [ENGINEERING_STATES], lowref [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) SPACE_PORT_BAFFEL_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) PCDM_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) PCDM_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (SpacePortBaffelTemperature, sensor, highref, lowref, 
                     summarydata[SUMMARY_SPACE_PORT_BAFFEL_TEMPERATURE]);

  datalist.GetAverageValue ((int) EARTH_PORT_BAFFEL_TEMPERATURE, startindex, stopindex, sensor);
  datalist.GetAverageValue ((int) PCDM_HIGH_REFERENCE, startindex, stopindex, highref);
  datalist.GetAverageValue ((int) PCDM_LOW_REFERENCE,  startindex, stopindex, lowref);
  mopipfile.Compute (EarthPortBaffelTemperature, sensor, highref, lowref, 
                     summarydata[SUMMARY_EARTH_PORT_BAFFEL_TEMPERATURE]);
}
