/********** EngineeringInstrumentBlock5Group.h ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK5_GROUP_

  #define _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK5_GROUP_

  #include "EngineeringDataGroup.h"
  #include "EngineeringDataConstants.h"
  #include "MOPIPFile.h"

  class engineering_instrument_block5_group : public engineering_data_group {
    private :
      static int const COMPRESSOR_1_TEMPERATURE_OFFSET;
      static int const COMPRESSOR_2_TEMPERATURE_OFFSET;
      static int const TCMM_A_1_TEMPERATURE_OFFSET;
      static int const TCMM_A_2_TEMPERATURE_OFFSET;
      static int const TCMM_B_1_TEMPERATURE_OFFSET;
      static int const TCMM_B_2_TEMPERATURE_OFFSET;
      static int const PSM_TEMPERATURE_OFFSET;
      static int const BASEPLATE_1_TEMPERATURE_OFFSET;
      static int const BASEPLATE_2_TEMPERATURE_OFFSET;
      static int const BASEPLATE_3_TEMPERATURE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_instrument_block5_sensor { COMPRESSOR_1_TEMPERATURE, COMPRESSOR_2_TEMPERATURE,
                                                  TCMM_A_1_TEMPERATURE,     TCMM_A_2_TEMPERATURE,
                                                  TCMM_B_1_TEMPERATURE,     TCMM_B_2_TEMPERATURE,
                                                  PSM_TEMPERATURE,          BASEPLATE_1_TEMPERATURE,
                                                  BASEPLATE_2_TEMPERATURE,  BASEPLATE_3_TEMPERATURE };

    protected :

    public :
      engineering_instrument_block5_group ();
      ~engineering_instrument_block5_group ();

      void AddBlock       (unsigned char*);
      bool Define         (int32, int32, string const&, string const&);
      void GetSummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                           float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                           float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
  };

#endif
