/********** EngineeringInstrumentBlock5Group.C ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringInstrumentBlock5Group.h"

int const engineering_instrument_block5_group::COMPRESSOR_1_TEMPERATURE_OFFSET = 6;
int const engineering_instrument_block5_group::COMPRESSOR_2_TEMPERATURE_OFFSET = 8;
int const engineering_instrument_block5_group::TCMM_A_1_TEMPERATURE_OFFSET     = 42;
int const engineering_instrument_block5_group::TCMM_A_2_TEMPERATURE_OFFSET     = 44;
int const engineering_instrument_block5_group::TCMM_B_1_TEMPERATURE_OFFSET     = 46;
int const engineering_instrument_block5_group::TCMM_B_2_TEMPERATURE_OFFSET     = 48;
int const engineering_instrument_block5_group::PSM_TEMPERATURE_OFFSET          = 50;
int const engineering_instrument_block5_group::BASEPLATE_1_TEMPERATURE_OFFSET  = 52;
int const engineering_instrument_block5_group::BASEPLATE_2_TEMPERATURE_OFFSET  = 54;
int const engineering_instrument_block5_group::BASEPLATE_3_TEMPERATURE_OFFSET  = 56;
int const engineering_instrument_block5_group::FIELDCOUNT                      = 10;

engineering_instrument_block5_group :: engineering_instrument_block5_group ()
                                     : engineering_data_group ()
{
  ;
}


engineering_instrument_block5_group :: ~engineering_instrument_block5_group ()
{
  ;
}


void engineering_instrument_block5_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [COMPRESSOR_1_TEMPERATURE] = UnpackData (&blockdata [COMPRESSOR_1_TEMPERATURE_OFFSET]);
  housedata [COMPRESSOR_2_TEMPERATURE] = UnpackData (&blockdata [COMPRESSOR_2_TEMPERATURE_OFFSET]);
  housedata [TCMM_A_1_TEMPERATURE]     = UnpackData (&blockdata [TCMM_A_1_TEMPERATURE_OFFSET]);
  housedata [TCMM_A_2_TEMPERATURE]     = UnpackData (&blockdata [TCMM_A_2_TEMPERATURE_OFFSET]);
  housedata [TCMM_B_1_TEMPERATURE]     = UnpackData (&blockdata [TCMM_B_1_TEMPERATURE_OFFSET]);
  housedata [TCMM_B_2_TEMPERATURE]     = UnpackData (&blockdata [TCMM_B_2_TEMPERATURE_OFFSET]);
  housedata [PSM_TEMPERATURE]          = UnpackData (&blockdata [PSM_TEMPERATURE_OFFSET]);
  housedata [BASEPLATE_1_TEMPERATURE]  = UnpackData (&blockdata [BASEPLATE_1_TEMPERATURE_OFFSET]);
  housedata [BASEPLATE_2_TEMPERATURE]  = UnpackData (&blockdata [BASEPLATE_2_TEMPERATURE_OFFSET]);
  housedata [BASEPLATE_3_TEMPERATURE]  = UnpackData (&blockdata [BASEPLATE_3_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_instrument_block5_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                    string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Compressor 1 Temperature", "Compressor 2 Temperature", "TCMM A1 Temperature",
                                          "TCMM A2 Temperature", "TCMM B1 Temperature", "TCMM B2 Temperature", 
                                          "PSM Temperature", "Baseplate 1 Temperature", "Baseplate 2 Temperature",
                                          "Baseplate 3 Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Instrument Block5 Group", groupclass,
                                         "Engineering Instrument Block5 Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_instrument_block5_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) COMPRESSOR_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (CompressorTemperature1);
  mopipfile.Compute (CompressorTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_COMPRESSOR_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) COMPRESSOR_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (CompressorTemperature2);
  mopipfile.Compute (CompressorTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_COMPRESSOR_2_TEMPERATURE]);
 
  datalist.GetAverageValue ((int) TCMM_A_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TCMMTemperatureA1);
  mopipfile.Compute (TCMMTemperatureA1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TCMM_A_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) TCMM_A_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TCMMTemperatureA2);
  mopipfile.Compute (TCMMTemperatureA2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TCMM_A_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) TCMM_B_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TCMMTemperatureB1);
  mopipfile.Compute (TCMMTemperatureA1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TCMM_B_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) TCMM_B_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TCMMTemperatureB2);
  mopipfile.Compute (TCMMTemperatureA1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TCMM_B_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) PSM_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (PSMTemperature);
  mopipfile.Compute (PSMTemperature, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_PSM_TEMPERATURE]);

  datalist.GetAverageValue ((int) BASEPLATE_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (BaseplateTemperature1);
  mopipfile.Compute (BaseplateTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_BASEPLATE_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) BASEPLATE_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (BaseplateTemperature2);
  mopipfile.Compute (BaseplateTemperature2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_BASEPLATE_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) BASEPLATE_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (BaseplateTemperature3);
  mopipfile.Compute (BaseplateTemperature3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_BASEPLATE_3_TEMPERATURE]);
}
