/********** EngineeringInstrumentBlock3Group.h ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK3_GROUP_

  #define _MOPITT_L1_ENGINEERING_INSTRUMENT_BLOCK3_GROUP_

  #include "EngineeringDataGroup.h"
  #include "EngineeringDataConstants.h"
  #include "MOPIPFile.h"

  class engineering_instrument_block3_group : public engineering_data_group {
    private :
      static int const COMPRESSOR_1_CURRENT_OFFSET;
      static int const COMPRESSOR_2_CURRENT_OFFSET;
      static int const COMPRESSOR_1_POSITION_OFFSET;
      static int const COMPRESSOR_2_POSITION_OFFSET;
      static int const COMPRESSOR_X_VIBRATION_OFFSET;
      static int const COMPRESSOR_Y_VIBRATION_OFFSET;
      static int const COMPRESSOR_Z_VIBRATION_OFFSET;
      static int const DISPLACER_1_TEMPERATURE_OFFSET;
      static int const DISPLACER_2_TEMPERATURE_OFFSET;
      static int const DISPLACER_1_CURRENT_OFFSET;
      static int const DISPLACER_2_CURRENT_OFFSET;
      static int const DISPLACER_1_POSITION_OFFSET;
      static int const DISPLACER_2_POSITION_OFFSET;
      static int const DISPLACER_X_VIBRATION_OFFSET;
      static int const DISPLACER_Y_VIBRATION_OFFSET;
      static int const DISPLACER_Z_VIBRATION_OFFSET;
      static int const CDE_1_TEMPERATURE_OFFSET;
      static int const CDE_2_TEMPERATURE_OFFSET;
      static int const CDE_3_TEMPERATURE_OFFSET;
      static int const FIELDCOUNT;

      enum engineering_instrument_block3_sensor { COMPRESSOR_1_CURRENT,    COMPRESSOR_2_CURRENT,   
                                                  COMPRESSOR_1_POSITION,   COMPRESSOR_2_POSITION,  
                                                  COMPRESSOR_X_VIBRATION,  COMPRESSOR_Y_VIBRATION,
                                                  COMPRESSOR_Z_VIBRATION,  DISPLACER_1_TEMPERATURE, 
                                                  DISPLACER_2_TEMPERATURE, DISPLACER_1_CURRENT,    
                                                  DISPLACER_2_CURRENT,     DISPLACER_1_POSITION,
                                                  DISPLACER_2_POSITION,    DISPLACER_X_VIBRATION,   
                                                  DISPLACER_Y_VIBRATION,   DISPLACER_Z_VIBRATION,  
                                                  CDE_1_TEMPERATURE,       CDE_2_TEMPERATURE,
                                                  CDE_3_TEMPERATURE };

    protected :

    public :
      engineering_instrument_block3_group ();
      ~engineering_instrument_block3_group ();

      void AddBlock       (unsigned char*);
      bool Define         (int32, int32, string const&, string const&);
      void GetSummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES]);
  };

#endif
