/********** EngineeringInstrumentBlock3Group.C ************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringInstrumentBlock3Group.h"

int const engineering_instrument_block3_group::COMPRESSOR_1_CURRENT_OFFSET    = 28;
int const engineering_instrument_block3_group::COMPRESSOR_2_CURRENT_OFFSET    = 30;
int const engineering_instrument_block3_group::COMPRESSOR_1_POSITION_OFFSET   = 20;
int const engineering_instrument_block3_group::COMPRESSOR_2_POSITION_OFFSET   = 24;
int const engineering_instrument_block3_group::COMPRESSOR_X_VIBRATION_OFFSET  = 8;
int const engineering_instrument_block3_group::COMPRESSOR_Y_VIBRATION_OFFSET  = 10;
int const engineering_instrument_block3_group::COMPRESSOR_Z_VIBRATION_OFFSET  = 16;
int const engineering_instrument_block3_group::DISPLACER_1_TEMPERATURE_OFFSET = 46;
int const engineering_instrument_block3_group::DISPLACER_2_TEMPERATURE_OFFSET = 48;
int const engineering_instrument_block3_group::DISPLACER_1_CURRENT_OFFSET     = 32;
int const engineering_instrument_block3_group::DISPLACER_2_CURRENT_OFFSET     = 34;
int const engineering_instrument_block3_group::DISPLACER_1_POSITION_OFFSET    = 22;
int const engineering_instrument_block3_group::DISPLACER_2_POSITION_OFFSET    = 26;
int const engineering_instrument_block3_group::DISPLACER_X_VIBRATION_OFFSET   = 12;
int const engineering_instrument_block3_group::DISPLACER_Y_VIBRATION_OFFSET   = 14;
int const engineering_instrument_block3_group::DISPLACER_Z_VIBRATION_OFFSET   = 18;
int const engineering_instrument_block3_group::CDE_1_TEMPERATURE_OFFSET       = 40;
int const engineering_instrument_block3_group::CDE_2_TEMPERATURE_OFFSET       = 42;
int const engineering_instrument_block3_group::CDE_3_TEMPERATURE_OFFSET       = 44;
int const engineering_instrument_block3_group::FIELDCOUNT                     = 19;

engineering_instrument_block3_group :: engineering_instrument_block3_group ()
                                     : engineering_data_group ()
{
  ;
}


engineering_instrument_block3_group :: ~engineering_instrument_block3_group ()
{
  ;
}


void engineering_instrument_block3_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [COMPRESSOR_1_CURRENT]      = UnpackData (&blockdata [COMPRESSOR_1_CURRENT_OFFSET]);
  housedata [COMPRESSOR_2_CURRENT]      = UnpackData (&blockdata [COMPRESSOR_2_CURRENT_OFFSET]);
  housedata [COMPRESSOR_1_POSITION]     = UnpackData (&blockdata [COMPRESSOR_1_POSITION_OFFSET]);
  housedata [COMPRESSOR_2_POSITION]     = UnpackData (&blockdata [COMPRESSOR_2_POSITION_OFFSET]);
  housedata [COMPRESSOR_X_VIBRATION]    = UnpackData (&blockdata [COMPRESSOR_X_VIBRATION_OFFSET]);
  housedata [COMPRESSOR_Y_VIBRATION]    = UnpackData (&blockdata [COMPRESSOR_Y_VIBRATION_OFFSET]);
  housedata [COMPRESSOR_Z_VIBRATION]    = UnpackData (&blockdata [COMPRESSOR_Z_VIBRATION_OFFSET]);
  housedata [DISPLACER_1_TEMPERATURE]   = UnpackData (&blockdata [DISPLACER_1_TEMPERATURE_OFFSET]);
  housedata [DISPLACER_2_TEMPERATURE]   = UnpackData (&blockdata [DISPLACER_2_TEMPERATURE_OFFSET]);
  housedata [DISPLACER_1_CURRENT]       = UnpackData (&blockdata [DISPLACER_1_CURRENT_OFFSET]);
  housedata [DISPLACER_2_CURRENT]       = UnpackData (&blockdata [DISPLACER_2_CURRENT_OFFSET]);
  housedata [DISPLACER_1_POSITION]      = UnpackData (&blockdata [DISPLACER_1_POSITION_OFFSET]);
  housedata [DISPLACER_2_POSITION]      = UnpackData (&blockdata [DISPLACER_2_POSITION_OFFSET]);
  housedata [DISPLACER_X_VIBRATION]     = UnpackData (&blockdata [DISPLACER_X_VIBRATION_OFFSET]);
  housedata [DISPLACER_Y_VIBRATION]     = UnpackData (&blockdata [DISPLACER_Y_VIBRATION_OFFSET]);
  housedata [DISPLACER_Z_VIBRATION]     = UnpackData (&blockdata [DISPLACER_Z_VIBRATION_OFFSET]);
  housedata [CDE_1_TEMPERATURE]         = UnpackData (&blockdata [CDE_1_TEMPERATURE_OFFSET]);
  housedata [CDE_2_TEMPERATURE]         = UnpackData (&blockdata [CDE_2_TEMPERATURE_OFFSET]);
  housedata [CDE_3_TEMPERATURE]         = UnpackData (&blockdata [CDE_3_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_instrument_block3_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                    string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Compressor 1 Current", "Compressor 2 Current", "Compressor 1 Position",
                                          "Compressor 2 Position", "Compressor X Vibration", "Compressor Y Vibration", 
                                          "Compressor Z Vibration", "Displacer 1 Temperature", 
                                          "Displacer 2 Temperature", "Displacer 1 Current", "Displacer 2 Current", 
                                          "Displacer 1 Position", "Displacer 2 Position", "Displacer X Vibration", 
                                          "Displacer Y Vibration", "Displacer Z Vibration", "CDE 1 Temperature", 
                                          "CDE 2 Temperature", "CDE 3 Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16,
                                        DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Instrument Block 3 Group", groupclass,
                                         "Engineering Instrument Block 3 Data", dataclass, FIELDCOUNT, fieldnames,
                                          datatypes, orders);
} 


void engineering_instrument_block3_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) COMPRESSOR_1_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorCurrent1, sensor, summarydata[SUMMARY_COMPRESSOR_1_CURRENT]);

  datalist.GetAverageValue ((int) COMPRESSOR_2_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorCurrent2, sensor, summarydata[SUMMARY_COMPRESSOR_2_CURRENT]);

  datalist.GetAverageValue ((int) COMPRESSOR_1_POSITION, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorPosition1, sensor, summarydata[SUMMARY_COMPRESSOR_1_POSITION]);

  datalist.GetAverageValue ((int) COMPRESSOR_2_POSITION, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorPosition2, sensor, summarydata[SUMMARY_COMPRESSOR_2_POSITION]);

  datalist.GetAverageValue ((int) COMPRESSOR_X_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorVibrationX, sensor, summarydata[SUMMARY_COMPRESSOR_X_VIBRATION]);

  datalist.GetAverageValue ((int) COMPRESSOR_Y_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorVibrationY, sensor, summarydata[SUMMARY_COMPRESSOR_Y_VIBRATION]);

  datalist.GetAverageValue ((int) COMPRESSOR_Z_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (CompressorVibrationZ, sensor, summarydata[SUMMARY_COMPRESSOR_Z_VIBRATION]);

  datalist.GetAverageValue ((int) DISPLACER_1_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerTemperature1, sensor, summarydata[SUMMARY_DISPLACER_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) DISPLACER_2_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerTemperature2, sensor, summarydata[SUMMARY_DISPLACER_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) DISPLACER_1_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerCurrent1, sensor, summarydata[SUMMARY_DISPLACER_1_CURRENT]);

  datalist.GetAverageValue ((int) DISPLACER_2_CURRENT, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerCurrent2, sensor, summarydata[SUMMARY_DISPLACER_2_CURRENT]);

  datalist.GetAverageValue ((int) DISPLACER_1_POSITION, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerPosition1, sensor, summarydata[SUMMARY_DISPLACER_1_POSITION]);

  datalist.GetAverageValue ((int) DISPLACER_2_POSITION, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerPosition2, sensor, summarydata[SUMMARY_DISPLACER_2_POSITION]);

  datalist.GetAverageValue ((int) DISPLACER_X_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerVibrationX, sensor, summarydata[SUMMARY_DISPLACER_X_VIBRATION]);

  datalist.GetAverageValue ((int) DISPLACER_Y_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerVibrationY, sensor, summarydata[SUMMARY_DISPLACER_Y_VIBRATION]);

  datalist.GetAverageValue ((int) DISPLACER_Z_VIBRATION, startindex, stopindex, sensor);
  mopipfile.Compute (DisplacerVibrationZ, sensor, summarydata[SUMMARY_DISPLACER_Z_VIBRATION]);

  datalist.GetAverageValue ((int) CDE_1_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (CDETemperature1, sensor, summarydata[SUMMARY_CDE_1_TEMPERATURE]);

  datalist.GetAverageValue ((int) CDE_2_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (CDETemperature2, sensor, summarydata[SUMMARY_CDE_2_TEMPERATURE]);

  datalist.GetAverageValue ((int) CDE_3_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (CDETemperature3, sensor, summarydata[SUMMARY_CDE_3_TEMPERATURE]);
}
