/********** EngineeringDataList.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringDataList.h"
#include <math.h>

engineering_data_list :: engineering_data_list ()
                       : datalist ()
{
  next = 0;
}


engineering_data_list :: ~engineering_data_list ()
{
  // make sure the list is empty
  unsigned short* engdata;
  while (! datalist.empty ()) {
    engdata = datalist.front ();
    delete engdata;
    datalist.pop_front ();
  }
}


void engineering_data_list :: AddData (unsigned short* engdata)
{
  datalist.push_back (engdata);
}


void engineering_data_list :: GetAverageValue (int offset, int startindex, int stopindex, 
                                               float average [ENGINEERING_STATES])
{
  // make a number counter to denote how many samples went into the average (this number will ALWAYS be greater than 0)
  int samples = (stopindex - startindex) + 1;

  // make a index location counter and initialize it to the place to start
  int counter = startindex;

  // make an iterator and initialize it to the starting point
  deque <unsigned short*> :: iterator iter = datalist.begin () + startindex;

  // get the average value within the index range
  double doubleaverage = 0.0;
  for (; iter != datalist.end () && counter <= stopindex; iter++) {
    doubleaverage += (double) *((*iter) + offset);
    counter++;
  }
  doubleaverage /= (double) samples;
  average [ENGINEERING_AVERAGE_VALUE] = (float) doubleaverage;

  // now compute the variance
  counter = startindex;
  double doublevariance = 0.0;
  iter = datalist.begin () + startindex;
  for (; iter != datalist.end () && counter <= stopindex; iter++) {
    doublevariance += pow (((double) *((*iter) + offset) - doubleaverage), 2.0);
    counter++;
  }
  if (samples > 1) 
    average [ENGINEERING_VARIANCE_VALUE] = (float) (doublevariance / (double) (samples - 1));
  else
    average [ENGINEERING_VARIANCE_VALUE] = 0.0;
}


bool engineering_data_list :: GetNext (unsigned short** datavalues)
{
  bool isfound = false;
 
  deque <unsigned short*> :: const_iterator iter = datalist.begin () + next;
  if (iter != datalist.end ()) {
    *datavalues = (unsigned short*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}
