/********** EngineeringDataGroup.h ************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_DATA_GROUP_

  #define _MOPITT_L1_ENGINEERING_DATA_GROUP_

  #include "mfhdf.h"
  #include "EngineeringDataList.h"
  #include "HDFVGroup.h"
  #include "HDFVData.h"

  class engineering_data_group {
    private :
      hdf_vgroup vgroup;
      hdf_vdata  vdata;

    protected :
      engineering_data_list datalist;

      bool           Define     (int32, int32, string const&, string const&, string const&, string const&, int, 
                                 string const [], int32 const [], int32 const []);
      unsigned short UnpackData (unsigned char* dataptr) const 
                                 {return (unsigned short) (dataptr [0] * 256) + dataptr [1];}

    public :
      engineering_data_group ();
      virtual ~engineering_data_group () = 0;

      bool Close ();
      bool Write ();
  };

#endif
