/********** EngineeringDataGroup.C ************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringDataGroup.h"

engineering_data_group :: engineering_data_group ()
                        : vgroup ()
                        , vdata ()
                        , datalist ()
{
  ;
}


engineering_data_group :: ~engineering_data_group ()
{
  ;
}


bool engineering_data_group :: Define (int32 fileid, int32 groupid, string const& groupname, string const& groupclass,
                                       string const& dataname, string const& dataclass, int fieldcount, 
                                       string const fieldnames [], int32 const datatypes [], int32 const orders [])
{
  bool isdefined = false;

  if (vgroup.Create (groupname, groupclass, fileid))
    if (vdata.Create (dataname, dataclass, fileid))
      if (vdata.Define (fieldcount, datatypes, orders, fieldnames))
        if (vdata.Set (fieldcount, fieldnames))
          if (vdata.Insert (vgroup.GetID ()))
            if (vgroup.Insert (groupid))
              isdefined = true;

  return isdefined;
}


bool engineering_data_group :: Close ()
{
  bool isclosed = false;

  if (vgroup.Close ())
    if (vdata.Close ())
      isclosed = true;

  return isclosed;
}


bool engineering_data_group :: Write ()
{
  bool iswritten = true;
  unsigned short* datavalues = NULL;

  // while there are no errors AND there are entries in the list
  while (iswritten && datalist.GetNext (&datavalues)) {

    // write the data
    if (! vdata.Write ((void*) datavalues))
      iswritten = false;
  }

  return iswritten;
}
