/********** EngineeringDataConstants.h ********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_DATA_CONSTANTS_

  #define _MOPITT_L1_ENGINEERING_DATA_CONSTANTS_

  #include "ScienceConstants.h"

  float const ENGINEERING_MISSING_VALUE  = -9999.0;
  int const   ENGINEERING_STATES         = 2;
  int const   ENGINEERING_SUMMARY_VALUES = 117;
  int const   ENGINEERING_SWATH_VALUES   = 34;
  int const   ENGINEERING_TRAINS         = SCIENCE_TRAINS;
  int const   DIODE_BANKS                = 2;
  int const   THERMISTOR_BANKS           = 4;
  int const   ENGINEERING_LISTS          = 5;

  enum engineering_list_offset {TELEM, BLOCK3, BLOCK4, BLOCK5, BLOCK8};

  enum engineering_states_offset { ENGINEERING_AVERAGE_VALUE, ENGINEERING_VARIANCE_VALUE };

  enum engineering_swath_offset { SWATH_CHOPPER_1_TEMPERATURE,      SWATH_CHOPPER_2_TEMPERATURE,
                                  SWATH_CHOPPER_3_TEMPERATURE,      SWATH_CHOPPER_4_TEMPERATURE,
                                  SWATH_COLDFILTER_1_TEMPERATURE,   SWATH_COLDFILTER_3_TEMPERATURE,
                                  SWATH_COLDFILTER_5_TEMPERATURE,   SWATH_COLDFILTER_7_TEMPERATURE,
                                  SWATH_DETECTOR_1_TEMPERATURE,     SWATH_DETECTOR_2_TEMPERATURE,
                                  SWATH_DETECTOR_3_TEMPERATURE,     SWATH_DETECTOR_4_TEMPERATURE,
                                  SWATH_DETECTOR_5_TEMPERATURE,     SWATH_DETECTOR_6_TEMPERATURE,
                                  SWATH_DETECTOR_7_TEMPERATURE,     SWATH_DETECTOR_8_TEMPERATURE,
                                  SWATH_LMC_1_SHROUD_TEMPERATURE,   SWATH_LMC_2_SHROUD_TEMPERATURE,
                                  SWATH_LMC_3_SHROUD_TEMPERATURE,   SWATH_LMC_4_SHROUD_TEMPERATURE,
                                  SWATH_LMC_1_PRESSURE_TEMPERATURE, SWATH_LMC_2_PRESSURE_TEMPERATURE,
                                  SWATH_LMC_3_PRESSURE_TEMPERATURE, SWATH_LMC_4_PRESSURE_TEMPERATURE,
                                  SWATH_LMC_1_PRESSURE,             SWATH_LMC_2_PRESSURE,
                                  SWATH_LMC_3_PRESSURE,             SWATH_LMC_4_PRESSURE,
                                  SWATH_PMC_1_SHROUD_TEMPERATURE,   SWATH_PMC_2_SHROUD_TEMPERATURE,
                                  SWATH_PMC_1_HIGH_STROKE_PRESSURE, SWATH_PMC_2_HIGH_STROKE_PRESSURE,
                                  SWATH_PMC_1_LOW_STROKE_PRESSURE,  SWATH_PMC_2_LOW_STROKE_PRESSURE };

  enum engineering_summary_offset { SUMMARY_BLACKBODY_1_TEMPERATURE_1,     SUMMARY_BLACKBODY_1_TEMPERATURE_2,
                                    SUMMARY_BLACKBODY_2_TEMPERATURE_1,     SUMMARY_BLACKBODY_2_TEMPERATURE_2,
                                    SUMMARY_BLACKBODY_3_TEMPERATURE_1,     SUMMARY_BLACKBODY_3_TEMPERATURE_2,
                                    SUMMARY_BLACKBODY_4_TEMPERATURE_1,     SUMMARY_BLACKBODY_4_TEMPERATURE_2,
                                    SUMMARY_BLACKBODY_1_HEATER_VOLTAGE,    SUMMARY_BLACKBODY_2_HEATER_VOLTAGE,
                                    SUMMARY_BLACKBODY_3_HEATER_VOLTAGE,    SUMMARY_BLACKBODY_4_HEATER_VOLTAGE,
                                    SUMMARY_CHOPPER_1_TEMPERATURE,         SUMMARY_CHOPPER_2_TEMPERATURE,
                                    SUMMARY_CHOPPER_3_TEMPERATURE,         SUMMARY_CHOPPER_4_TEMPERATURE,
                                    SUMMARY_CHOPPER_1_MOTOR_CURRENT,       SUMMARY_CHOPPER_2_MOTOR_CURRENT,
                                    SUMMARY_CHOPPER_3_MOTOR_CURRENT,       SUMMARY_CHOPPER_4_MOTOR_CURRENT,
                                    SUMMARY_COLD_FILTER_1_TEMPERATURE,     SUMMARY_COLD_FILTER_3_TEMPERATURE,
                                    SUMMARY_COLD_FILTER_5_TEMPERATURE,     SUMMARY_COLD_FILTER_7_TEMPERATURE,
                                    SUMMARY_COLD_TIP_1_NARROW_TEMPERATURE, SUMMARY_COLD_TIP_1_WIDE_TEMPERATURE,
                                    SUMMARY_COLD_TIP_2_NARROW_TEMPERATURE, SUMMARY_COLD_TIP_2_WIDE_TEMPERATURE,
                                    SUMMARY_DETECTOR_1_TEMPERATURE,        SUMMARY_DETECTOR_2_TEMPERATURE,
                                    SUMMARY_DETECTOR_3_TEMPERATURE,        SUMMARY_DETECTOR_4_TEMPERATURE,
                                    SUMMARY_DETECTOR_5_TEMPERATURE,        SUMMARY_DETECTOR_6_TEMPERATURE,
                                    SUMMARY_DETECTOR_7_TEMPERATURE,        SUMMARY_DETECTOR_8_TEMPERATURE,
                                    SUMMARY_LMC_1_TEMPERATURE,             SUMMARY_LMC_2_TEMPERATURE,
                                    SUMMARY_LMC_3_TEMPERATURE,             SUMMARY_LMC_4_TEMPERATURE,
                                    SUMMARY_LMC_1_PRESSURE_TEMPERATURE,    SUMMARY_LMC_2_PRESSURE_TEMPERATURE,
                                    SUMMARY_LMC_3_PRESSURE_TEMPERATURE,    SUMMARY_LMC_4_PRESSURE_TEMPERATURE,
                                    SUMMARY_LMC_1_PRESSURE,                SUMMARY_LMC_2_PRESSURE,
                                    SUMMARY_LMC_3_PRESSURE,                SUMMARY_LMC_4_PRESSURE,
                                    SUMMARY_LMC_1_MOTOR_CURRENT,           SUMMARY_LMC_2_MOTOR_CURRENT,
                                    SUMMARY_LMC_3_MOTOR_CURRENT,           SUMMARY_LMC_4_MOTOR_CURRENT,
                                    SUMMARY_MIRROR_1_MOTOR_TEMPERATURE,    SUMMARY_MIRROR_2_MOTOR_TEMPERATURE,
                                    SUMMARY_MIRROR_3_MOTOR_TEMPERATURE,    SUMMARY_MIRROR_4_MOTOR_TEMPERATURE,
                                    SUMMARY_MIRROR_1_MOTOR_CURRENT,        SUMMARY_MIRROR_2_MOTOR_CURRENT,
                                    SUMMARY_MIRROR_3_MOTOR_CURRENT,        SUMMARY_MIRROR_4_MOTOR_CURRENT,
                                    SUMMARY_PMC_1_TEMPERATURE,             SUMMARY_PMC_2_TEMPERATURE,
                                    SUMMARY_PMC_1_AMPLITUDE,               SUMMARY_PMC_2_AMPLITUDE,
                                    SUMMARY_PMC_1_PHASE_ERROR,             SUMMARY_PMC_2_PHASE_ERROR,
                                    SUMMARY_PMC_1_MOTOR_CURRENT,           SUMMARY_PMC_2_MOTOR_CURRENT,
                                    SUMMARY_SIEVE_1_TEMPERATURE,           SUMMARY_SIEVE_2_TEMPERATURE,
                                    SUMMARY_SIEVE_3_TEMPERATURE,           SUMMARY_SIEVE_4_TEMPERATURE,
                                    SUMMARY_SIEVE_1_HEATER_VOLTAGE,        SUMMARY_SIEVE_2_HEATER_VOLTAGE,
                                    SUMMARY_SIEVE_3_HEATER_VOLTAGE,        SUMMARY_SIEVE_4_HEATER_VOLTAGE,
                                    SUMMARY_SPM_1_TEMPERATURE,             SUMMARY_SPM_2_TEMPERATURE,
                                    SUMMARY_TABLE_1_TEMPERATURE_1,         SUMMARY_TABLE_1_TEMPERATURE_2,
                                    SUMMARY_TABLE_1_TEMPERATURE_3,         SUMMARY_TABLE_1_TEMPERATURE_4,
                                    SUMMARY_TABLE_2_TEMPERATURE_1,         SUMMARY_TABLE_2_TEMPERATURE_2,
                                    SUMMARY_TABLE_2_TEMPERATURE_3,         SUMMARY_TABLE_2_TEMPERATURE_4,
                                    SUMMARY_TCMM_A_TEMPERATURE_1,          SUMMARY_TCMM_A_TEMPERATURE_2,
                                    SUMMARY_TCMM_B_TEMPERATURE_1,          SUMMARY_TCMM_B_TEMPERATURE_2,
                                    SUMMARY_EARTH_PORT_BAFFEL_TEMPERATURE, SUMMARY_SPACE_PORT_BAFFEL_TEMPERATURE,
                                    SUMMARY_BASEPLATE_1_TEMPERATURE,       SUMMARY_BASEPLATE_2_TEMPERATURE,
                                    SUMMARY_BASEPLATE_3_TEMPERATURE,       SUMMARY_PSM_TEMPERATURE,
                                    SUMMARY_COMPRESSOR_1_CURRENT,          SUMMARY_COMPRESSOR_2_CURRENT,
                                    SUMMARY_COMPRESSOR_1_POSITION,         SUMMARY_COMPRESSOR_2_POSITION,
                                    SUMMARY_COMPRESSOR_1_TEMPERATURE,      SUMMARY_COMPRESSOR_2_TEMPERATURE,
                                    SUMMARY_DISPLACER_1_CURRENT,           SUMMARY_DISPLACER_2_CURRENT,
                                    SUMMARY_DISPLACER_1_POSITION,          SUMMARY_DISPLACER_2_POSITION,
                                    SUMMARY_DISPLACER_1_TEMPERATURE,       SUMMARY_DISPLACER_2_TEMPERATURE,
                                    SUMMARY_COMPRESSOR_X_VIBRATION,        SUMMARY_DISPLACER_X_VIBRATION,
                                    SUMMARY_COMPRESSOR_Y_VIBRATION,        SUMMARY_DISPLACER_Y_VIBRATION,
                                    SUMMARY_COMPRESSOR_Z_VIBRATION,        SUMMARY_DISPLACER_Z_VIBRATION,
                                    SUMMARY_CDE_1_TEMPERATURE,             SUMMARY_CDE_2_TEMPERATURE,
				    SUMMARY_CDE_3_TEMPERATURE };

#endif
