/********** EngineeringData.h *****************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_DATA_

  #define _MOPITT_L1_ENGINEERING_DATA_

  #include "MOPIPFile.h"
  #include "EngineeringDataConstants.h"
  #include "EngineeringTimeData.h"
  #include "EngineeringInstrumentData.h"
  #include "EngineeringBench1Data.h"
  #include "EngineeringBench2Data.h"
  #include "EngineeringTrain1Data.h"
  #include "EngineeringTrain2Data.h"
  #include "EngineeringTrain3Data.h"
  #include "EngineeringTrain4Data.h"

  class engineering_data {
    private :
      static int const OVERLAP_WARNING;
      static int const TRAIN_WARNING;
 
      engineering_time_data       timedata;
      engineering_instrument_data instrumentdata;
      engineering_bench1_data     bench1data;
      engineering_bench2_data     bench2data;
      engineering_train1_data     train1data;
      engineering_train2_data     train2data;
      engineering_train3_data     train3data;
      engineering_train4_data     train4data;
      int                         swathindex;
      int                         trainindex [ENGINEERING_TRAINS];
      int                         summaryindex [ENGINEERING_LISTS];

      void WriteIndecesDiagnostic (mopitt_time const&, mopitt_time const&) const;

    protected :

    public :
      engineering_data ();
      ~engineering_data ();

      void  AddBlock            (engineering_block*);
      bool  Close               ();
      bool  Define              (int32, int32);
      float GetEventTemperature (int, mopitt_time const&, mopitt_time const&, mopip_file const&);
      void  GetSummaryData      (mopitt_time const&, mopitt_time const&, mopip_file const&,
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetSwathData        (mopitt_time const&, mopitt_time const&, mopip_file const&,
                                 float [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES]);
      bool  Write               ();
  };

#endif
