/********** EngineeringCollection.h ***********************************************************************************\

 $Header$

 REVISION HISTORY
   06/98   Charles Cavanaugh
   06/99   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_COLLECTION_

  #define _MOPITT_L1_ENGINEERING_COLLECTION_

  #include "L0Collection.h"
  #include "EngineeringData.h"
  #include "EngineeringPacket.h"

  PGSt_PC_Logical const ENGINEERING_COLLECTION_01_LOGICAL = 41100;
  PGSt_PC_Logical const ENGINEERING_COLLECTION_02_LOGICAL = (ENGINEERING_COLLECTION_01_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_03_LOGICAL = (ENGINEERING_COLLECTION_02_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_04_LOGICAL = (ENGINEERING_COLLECTION_03_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_05_LOGICAL = (ENGINEERING_COLLECTION_04_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_06_LOGICAL = (ENGINEERING_COLLECTION_05_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_07_LOGICAL = (ENGINEERING_COLLECTION_06_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_08_LOGICAL = (ENGINEERING_COLLECTION_07_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_09_LOGICAL = (ENGINEERING_COLLECTION_08_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_10_LOGICAL = (ENGINEERING_COLLECTION_09_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_11_LOGICAL = (ENGINEERING_COLLECTION_10_LOGICAL + 1);
  PGSt_PC_Logical const ENGINEERING_COLLECTION_12_LOGICAL = (ENGINEERING_COLLECTION_11_LOGICAL + 1);

  class engineering_collection : public l0_collection {
    private :
      static int const APID;
      static int const PACKETSIZE;
      static int const PACKETLENGTH;
      static int const APID_ERROR;
      static int const LENGTH_ERROR;
      static int const ID_WARNING;

      engineering_data engineeringdata;

      engineering_packet* GetPacket ();

    protected :

    public :
      engineering_collection ();
      ~engineering_collection ();

      float GetEventTemperature (int, mopitt_time const&, mopitt_time const&, mopip_file const&);
      void  GetSummaryData      (mopitt_time const&, mopitt_time const&, mopip_file const&,
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void  GetSwathData        (mopitt_time const&, mopitt_time const&, mopip_file const&,
                                 float [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES]);
      void  Ingest              ();
      bool  Write               (int32, int32);
  };

#endif
