/********** EngineeringCollection.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   06/98   Charles Cavanaugh
   06/99   Tom Lauren
   05/00   Daniel Ziskin
   09/00   Daniel Ziskin
   07/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "EngineeringCollection.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const engineering_collection::APID         = 193;
int const engineering_collection::PACKETSIZE   = 3200;
int const engineering_collection::PACKETLENGTH = PACKETSIZE - CCSDS_HEADER_LENGTH;
int const engineering_collection::APID_ERROR   = 901;
int const engineering_collection::LENGTH_ERROR = 902;
int const engineering_collection::ID_WARNING   = 803;

engineering_collection :: engineering_collection ()
                        : l0_collection (ENGINEERING_COLLECTION_01_LOGICAL, PACKETSIZE)
{
  ;
}


engineering_collection :: ~engineering_collection ()
{
  ;
}


engineering_packet* engineering_collection :: GetPacket ()
{
  engineering_packet* engineeringpacket = NULL;
  PGSt_IO_L0_Packet* data;
  static int oldsequence = -1;

  // while still searching for a valid packet
  bool findanotherpacket = true;
  while (findanotherpacket) {
  
    // get a l0 packet
    data = new PGSt_IO_L0_Packet [PACKETSIZE];
    if (! l0_collection::GetPacket (data)) {
      delete [] data;
      findanotherpacket = false;
    }
    else {

      // make a new engineering packet
      engineeringpacket = new engineering_packet (data);
      int sequence = engineeringpacket->GetSequence ();

      if (engineeringpacket->GetAPID () != APID) {
        string message = engineeringpacket->MakeWrongAPIDMessage ();
        delete engineeringpacket;
        engineeringpacket = NULL;
        diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_ENGINEERING_MODULE, APID_ERROR, 
                                     GetCurrentLogical (), 0, sequence, 0, 0, 0, 0, 0, message);
      }
      else if (engineeringpacket->GetLength () != PACKETLENGTH) {
        string message = engineeringpacket->MakeWrongLengthMessage ();
        delete engineeringpacket;
        engineeringpacket = NULL;
        diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_ENGINEERING_MODULE, LENGTH_ERROR, 
                                     GetCurrentLogical (), 0, sequence, 0, 0, 0, 0, 0, message);
      }
      else {
        findanotherpacket = false;
        if ((engineeringpacket->SequenceGap (oldsequence, sequence)) && (oldsequence >= 0)) {
          string message = engineeringpacket->MakeSequenceGapMessage (oldsequence, sequence);
          diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_ENGINEERING_MODULE,
                                       engineeringpacket->GetSequenceErrCode (), GetCurrentLogical (), 0,
                                       sequence, 0, 0, 0, 0, 0, message);
        }
        oldsequence = sequence;
      }
    }
  }
  
  return engineeringpacket;
}


float engineering_collection :: GetEventTemperature (int train, mopitt_time const& starttime, 
                                                     mopitt_time const& stoptime, mopip_file const& mopipfile)
{
  return engineeringdata.GetEventTemperature (train, starttime, stoptime, mopipfile);
}


void engineering_collection :: GetSummaryData (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                               mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  engineeringdata.GetSummaryData (starttime, stoptime, mopipfile, summaryengineering);
}


void engineering_collection :: GetSwathData (mopitt_time const& starttime, mopitt_time const& stoptime, 
                                             mopip_file const& mopipfile,
                                             float swathengineering [ENGINEERING_SWATH_VALUES][ENGINEERING_STATES])
{
  engineeringdata.GetSwathData (starttime, stoptime, mopipfile, swathengineering);
}


void engineering_collection :: Ingest ()
{
  engineering_block* engineeringblock;
  engineering_packet* engineeringpacket;

  // while there are packets in the file
  while ((engineeringpacket = GetPacket ()) != NULL) {

    // get the next block from the packet and make sure the id is ok; if so, add block data to storage
    while ((engineeringblock = engineeringpacket->GetBlock (GetCurrentLogical(), engineeringpacket->GetSequence())) 
         != NULL) {
      if (engineeringblock->HasCorrectID ()) 
        engineeringdata.AddBlock (engineeringblock);
      else {
        string message = "Incorrect engineering block id : ";
        message += engineeringblock->GetID ();
        diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_ENGINEERING_MODULE, ID_WARNING, 
                                     GetCurrentLogical (), 0, engineeringpacket->GetSequence (), 0, 0, 0, 0, 
                                     engineeringblock->GetBlockNumber (), message);
      }

      delete engineeringblock;
    }

    // delete the packet object
    delete engineeringpacket;
  }
}


bool engineering_collection :: Write (int32 fileid, int32 engineeringid)
{
  bool iswritten = false;

  if (engineeringdata.Define (fileid, engineeringid))
    if (engineeringdata.Write ())
      if (engineeringdata.Close ())
        iswritten = true;

  return iswritten;
}
