/********** EngineeringBlock.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   05/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_BLOCK_

  #define _MOPITT_L1_ENGINEERING_BLOCK_

  #include "MOPITTTime.h"

  int const ENGINEERING_BLOCK_SIZE  = 398;
  int const ENGINEERING_HOUSE_SIZE  = 64;
  int const ENGINEERING_HOUSE_START = 268;
  int const ENGINEERING_TELEM_START = 10;
  int const ENGINEERING_TELEM_SIZE  = 256;

  class engineering_block {
    private :
      static int const ID_START;
      static int const BLOCKNUMBER_START;
      static int const TIME_START;
      static int const MSEC_WARNING;
      static int const BLOCKNUM_WARNING;

      void Set (mopitt_time const&, unsigned char*, PGSt_PC_Logical, int);

    protected :
      unsigned char* data;
      unsigned char  id;
      mopitt_time    time;
      int            blocknumber;

    public :
      engineering_block ();
      engineering_block (mopitt_time const&, unsigned char*, PGSt_PC_Logical, int);
      ~engineering_block ();

      int                GetBlockNumber () const {return blocknumber;}
      unsigned char*     GetHouseData   () const;
      unsigned char      GetID          () const {return id;}
      mopitt_time const& GetTime        () const {return time;}
      unsigned char*     GetTelemData   () const;
      bool               HasCorrectID   () const {return (id == 'E');}
  };

#endif
