/********** EngineeringBlock.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   05/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#include <memory.h>
#include "EngineeringBlock.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const engineering_block::ID_START          = 0;
int const engineering_block::BLOCKNUMBER_START = 266;
int const engineering_block::TIME_START        = 6;
int const engineering_block::MSEC_WARNING      = 864;
int const engineering_block::BLOCKNUM_WARNING  = 808;

engineering_block :: engineering_block ()
                   : time ()
{
  data = NULL;
  id = 0;
  blocknumber = 0;
}


engineering_block :: engineering_block (mopitt_time const& packettime, unsigned char* blockdata, 
                                        PGSt_PC_Logical CurrentLogical, int sequence)
{
  Set (packettime, blockdata, CurrentLogical, sequence);
}


engineering_block :: ~engineering_block ()
{
  delete [] data;
}


void engineering_block :: Set (mopitt_time const& packettime, unsigned char* blockdata, PGSt_PC_Logical currentlogical,
                               int sequence)
{
  // make room for the data and copy it
  data = new unsigned char [ENGINEERING_BLOCK_SIZE];
  (void) memcpy ((void*) data, (const void*) blockdata, ENGINEERING_BLOCK_SIZE);

  // get the id
  id = data [ID_START];

  // get the block number
  blocknumber = (int) ((data [BLOCKNUMBER_START] + 1) - '0');

  if ((blocknumber < 0 ) || (blocknumber > 8 )) {
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_ENGINEERING_MODULE, BLOCKNUM_WARNING, 
				 currentlogical, 0, sequence, 0, 0, 0, 0, blocknumber,"blocknumber out of range");
    // Set the id to B - which is different than E
    id = 'B';
  }
 
  // get the block time and fix rollover if necessary
  int blockmsecs = (blockdata [TIME_START + 0] * 16777216) + (blockdata [TIME_START + 1] * 65536) +
                   (blockdata [TIME_START + 2] * 256) + (int) blockdata [TIME_START + 3];
  if (blockmsecs > 86400000)
    blockmsecs -= 86400000;

  // added by DZ 5/18/00
  if ((blockmsecs < 86400001 ) && (blockmsecs > -1)) {

    int blockday = packettime.GetDay ();
    if (blockmsecs > packettime.GetMsecs ())
      blockday--;

    time.Set (blockday, blockmsecs);
  }
  else    {
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_ENGINEERING_MODULE, MSEC_WARNING, 
				 currentlogical, 0, sequence, 0, 0, 0, 0, blocknumber, "blockmsecs out of range");
    // Set the id to M - which is different than E
    id='M';
  }
}


unsigned char* engineering_block :: GetHouseData () const
{
  // make the container
  unsigned char* housedata = new unsigned char [ENGINEERING_HOUSE_SIZE];

  // copy the data
  (void) memcpy ((void*) housedata, (const void*) &data[ENGINEERING_HOUSE_START], ENGINEERING_HOUSE_SIZE);

  return housedata;
}


unsigned char* engineering_block :: GetTelemData () const
{
  // make the container
  unsigned char* telemdata = new unsigned char [ENGINEERING_TELEM_SIZE];

  // copy the data
  (void) memcpy ((void*) telemdata, (const void*) &data[ENGINEERING_TELEM_START], ENGINEERING_TELEM_SIZE);

  return telemdata;
}
