/********** EngineeringBench2Data.h ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_BENCH2_DATA_

  #define _MOPITT_L1_ENGINEERING_BENCH2_DATA_

  #include "EngineeringBlock.h"
  #include "EngineeringBench2TelemGroup.h"
  #include "EngineeringBench2Block3Group.h"
  #include "EngineeringBench2Block4Group.h"
  #include "EngineeringBench2Block5Group.h"

  class engineering_bench2_data {
    private :
      engineering_bench2_telem_group  telemgroup;
      engineering_bench2_block3_group block3group;
      engineering_bench2_block4_group block4group;
      engineering_bench2_block5_group block5group;
      hdf_vgroup                      vgroup;

    protected :

    public :
      engineering_bench2_data ();
      ~engineering_bench2_data ();

      void AddBlock             (engineering_block*);
      bool Close                ();
      bool Define               (int32, int32, string const&);
      void GetTelemSummaryData  (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock3SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock4SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock5SummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      bool Write                ();
  };

#endif
