/********** EngineeringBench2Data.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringBench2Data.h"

engineering_bench2_data :: engineering_bench2_data ()
                         : telemgroup ()
                         , block3group ()
                         , block4group ()
                         , block5group ()
                         , vgroup ()
 
{
  ;
}


engineering_bench2_data :: ~engineering_bench2_data ()
{
  ;
}


void engineering_bench2_data :: AddBlock (engineering_block* engineeringblock)
{
  // add the data to the telem group
  unsigned char* telemdata = engineeringblock->GetTelemData ();
  telemgroup.AddBlock (telemdata);

  // if necessary, add the block data to the appropriate group
  unsigned char* blockdata;
  switch (engineeringblock->GetBlockNumber ()) {
    case 3 : blockdata = engineeringblock->GetHouseData ();
             block3group.AddBlock (blockdata);
             break;
    case 4 : blockdata = engineeringblock->GetHouseData ();
             block4group.AddBlock (blockdata);
             break;
    case 5 : blockdata = engineeringblock->GetHouseData ();
             block5group.AddBlock (blockdata);
             break;
    default : break;
  }
}


bool engineering_bench2_data :: Close ()
{
  bool isclosed = false;

  if (telemgroup.Close ())
    if (block3group.Close ())
      if (block4group.Close ())
        if (block5group.Close ())
          if (vgroup.Close ())
            isclosed = true;

  return isclosed;
}


bool engineering_bench2_data :: Define (int32 fileid, int32 engineeringid, string const& maingroupclass) 
{
  bool isdefined = false;
  string const groupclass = "Engineering Bench2 Group";
  string const dataclass  = "Engineering Bench2 Data";

  if (vgroup.Create (groupclass, maingroupclass, fileid))
    if (telemgroup.Define (fileid, vgroup.GetID (), groupclass, dataclass))
      if (block3group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
        if (block4group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
          if (block5group.Define (fileid, vgroup.GetID (), groupclass, dataclass))
            if (vgroup.Insert (engineeringid))
              isdefined = true;

  return isdefined;
}


void engineering_bench2_data :: GetTelemSummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                                      float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                      float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  telemgroup.GetSummaryData (startindex, stopindex, mopipfile, thermistorhighrefs, thermistorlowrefs, 
                             summaryengineering);
}


void engineering_bench2_data :: GetBlock3SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block3group.GetSummaryData (startindex, stopindex, mopipfile, summaryengineering);
}


void engineering_bench2_data :: GetBlock4SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block4group.GetSummaryData (startindex, stopindex, mopipfile, summaryengineering);
}


void engineering_bench2_data :: GetBlock5SummaryData (int startindex, int stopindex, mopip_file const& mopipfile,
                                                      float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                      float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                              float summaryengineering [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES])
{
  block5group.GetSummaryData (startindex, stopindex, mopipfile, thermistorhighrefs, thermistorlowrefs, 
                              summaryengineering);
}


bool engineering_bench2_data :: Write ()
{
  bool iswritten = false;

  if (telemgroup.Write  ())
    if (block3group.Write ())
      if (block4group.Write ())
        if (block5group.Write ())
          iswritten = true;

  return iswritten;
}
