/********** EngineeringBench2Block4Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringBench2Block4Group.h"

int const engineering_bench2_block4_group::COLD_TIP_2_NARROW_TEMPERATURE_OFFSET = 6;
int const engineering_bench2_block4_group::FIELDCOUNT                           = 1;

engineering_bench2_block4_group :: engineering_bench2_block4_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_bench2_block4_group :: ~engineering_bench2_block4_group ()
{
  ;
}


void engineering_bench2_block4_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [COLD_TIP_2_NARROW_TEMPERATURE] = UnpackData (&blockdata [COLD_TIP_2_NARROW_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_bench2_block4_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Cold Tip 2 Narrow Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Bench2 Block4 Group", groupclass,
                                         "Engineering Bench2 Block4 Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_bench2_block4_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) COLD_TIP_2_NARROW_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (ColdTipNarrowTemperature2, sensor, summarydata[SUMMARY_COLD_TIP_2_NARROW_TEMPERATURE]);
}
