/********** EngineeringBench1TelemGroup.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringBench1TelemGroup.h"

int const engineering_bench1_telem_group::TABLE_1_THERMISTOR_1_TEMPERATURE_OFFSET = 136;
int const engineering_bench1_telem_group::TABLE_1_THERMISTOR_2_TEMPERATURE_OFFSET = 138;
int const engineering_bench1_telem_group::TABLE_1_THERMISTOR_3_TEMPERATURE_OFFSET = 140;
int const engineering_bench1_telem_group::TABLE_1_THERMISTOR_4_TEMPERATURE_OFFSET = 142;
int const engineering_bench1_telem_group::FIELDCOUNT                              = 4;

engineering_bench1_telem_group :: engineering_bench1_telem_group ()
                                : engineering_data_group ()
{
  ;
}


engineering_bench1_telem_group :: ~engineering_bench1_telem_group ()
{
  ;
}


void engineering_bench1_telem_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* telemdata = new unsigned short [FIELDCOUNT];

  // unpack the data
  telemdata [TABLE_1_THERMISTOR_1_TEMPERATURE] = UnpackData (&blockdata [TABLE_1_THERMISTOR_1_TEMPERATURE_OFFSET]);
  telemdata [TABLE_1_THERMISTOR_2_TEMPERATURE] = UnpackData (&blockdata [TABLE_1_THERMISTOR_2_TEMPERATURE_OFFSET]);
  telemdata [TABLE_1_THERMISTOR_3_TEMPERATURE] = UnpackData (&blockdata [TABLE_1_THERMISTOR_3_TEMPERATURE_OFFSET]);
  telemdata [TABLE_1_THERMISTOR_4_TEMPERATURE] = UnpackData (&blockdata [TABLE_1_THERMISTOR_4_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (telemdata);
}


bool engineering_bench1_telem_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                               string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Table 1 Thermistor 1 Temperature", "Table 1 Thermistor 2 Temperature",
                                          "Table 1 Thermistor 3 Temperature", "Table 1 Thermistor 4 Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16, DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1, 1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Bench1 Telem Group", groupclass,
                                         "Engineering Bench1 Telem Data", dataclass, FIELDCOUNT, fieldnames, datatypes,
                                         orders);
}


void engineering_bench1_telem_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) TABLE_1_THERMISTOR_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TableTemperature1_1);
  mopipfile.Compute (TableTemperature1_1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TABLE_1_TEMPERATURE_1]);

  datalist.GetAverageValue ((int) TABLE_1_THERMISTOR_2_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TableTemperature1_2);
  mopipfile.Compute (TableTemperature1_2, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TABLE_1_TEMPERATURE_2]);

  datalist.GetAverageValue ((int) TABLE_1_THERMISTOR_3_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TableTemperature1_3);
  mopipfile.Compute (TableTemperature1_3, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TABLE_1_TEMPERATURE_3]);

  datalist.GetAverageValue ((int) TABLE_1_THERMISTOR_4_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (TableTemperature1_4);
  mopipfile.Compute (TableTemperature1_4, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_TABLE_1_TEMPERATURE_4]);

}
