/********** EngineeringBench1Data.h ***********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_ENGINEERING_BENCH1_DATA_

  #define _MOPITT_L1_ENGINEERING_BENCH1_DATA_

  #include "EngineeringBlock.h"
  #include "EngineeringBench1TelemGroup.h"
  #include "EngineeringBench1Block3Group.h"
  #include "EngineeringBench1Block5Group.h"

  class engineering_bench1_data {
    private :
      engineering_bench1_telem_group  telemgroup;
      engineering_bench1_block3_group block3group;
      engineering_bench1_block5_group block5group;
      hdf_vgroup                      vgroup;

    protected :

    public :
      engineering_bench1_data ();
      ~engineering_bench1_data ();

      void AddBlock             (engineering_block*);
      bool Close                ();
      bool Define               (int32, int32, string const&);
      void GetTelemSummaryData  (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock3SummaryData (int, int, mopip_file const&, float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      void GetBlock5SummaryData (int, int, mopip_file const&, float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                 float [ENGINEERING_SUMMARY_VALUES][ENGINEERING_STATES]);
      bool Write                ();
  };

#endif
