/********** EngineeringBench1Block5Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringBench1Block5Group.h"

int const engineering_bench1_block5_group::SPM_1_TEMPERATURE_OFFSET = 38;
int const engineering_bench1_block5_group::FIELDCOUNT               = 1;

engineering_bench1_block5_group :: engineering_bench1_block5_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_bench1_block5_group :: ~engineering_bench1_block5_group ()
{
  ;
}


void engineering_bench1_block5_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [SPM_1_TEMPERATURE] = UnpackData (&blockdata [SPM_1_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_bench1_block5_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"SPM 1 Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Bench1 Block5 Group", groupclass,
                                         "Engineering Bench1 Block5 Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_bench1_block5_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                       float thermistorhighrefs [THERMISTOR_BANKS] [ENGINEERING_STATES],
                                                       float thermistorlowrefs [THERMISTOR_BANKS] [ENGINEERING_STATES], 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];
  short bank;

  datalist.GetAverageValue ((int) SPM_1_TEMPERATURE, startindex, stopindex, sensor);
  bank = mopipfile.GetBank (SPMTemperature1);
  mopipfile.Compute (SPMTemperature1, sensor, thermistorhighrefs[bank - 1], thermistorlowrefs[bank - 1],
                     summarydata[SUMMARY_SPM_1_TEMPERATURE]);
}
