/********** EngineeringBench1Block3Group.C ****************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "EngineeringBench1Block3Group.h"

int const engineering_bench1_block3_group::COLD_TIP_1_WIDE_TEMPERATURE_OFFSET   = 56;
int const engineering_bench1_block3_group::COLD_TIP_1_NARROW_TEMPERATURE_OFFSET = 62;
int const engineering_bench1_block3_group::FIELDCOUNT                           = 2;

engineering_bench1_block3_group :: engineering_bench1_block3_group ()
                                 : engineering_data_group ()
{
  ;
}


engineering_bench1_block3_group :: ~engineering_bench1_block3_group ()
{
  ;
}


void engineering_bench1_block3_group :: AddBlock (unsigned char* blockdata)
{
  // make the container to hold the data we want
  unsigned short* housedata = new unsigned short [FIELDCOUNT];

  // unpack the data
  housedata [COLD_TIP_1_WIDE_TEMPERATURE]   = UnpackData (&blockdata [COLD_TIP_1_WIDE_TEMPERATURE_OFFSET]);
  housedata [COLD_TIP_1_NARROW_TEMPERATURE] = UnpackData (&blockdata [COLD_TIP_1_NARROW_TEMPERATURE_OFFSET]);

  // add the container to the list
  datalist.AddData (housedata);
}


bool engineering_bench1_block3_group :: Define (int32 fileid, int32 groupid, string const& groupclass,
                                                string const& dataclass)
{
  string const fieldnames [FIELDCOUNT] = {"Cold Tip 1 Wide Temperature", "Cold Tip 1 Narrow Temperature"};
  int32 const datatypes [FIELDCOUNT] = {DFNT_UINT16, DFNT_UINT16};
  int32 const orders [FIELDCOUNT] = {1, 1};

  return engineering_data_group::Define (fileid, groupid, "Engineering Bench1 Block3 Group", groupclass,
                                         "Engineering Bench1 Block3 Data", dataclass, FIELDCOUNT, fieldnames,
                                         datatypes, orders);
}


void engineering_bench1_block3_group :: GetSummaryData (int startindex, int stopindex, mopip_file const& mopipfile, 
                                                    float summarydata [ENGINEERING_SUMMARY_VALUES] [ENGINEERING_STATES])
{
  float sensor [ENGINEERING_STATES];

  datalist.GetAverageValue ((int) COLD_TIP_1_WIDE_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (ColdTipWideTemperature1, sensor, summarydata[SUMMARY_COLD_TIP_1_WIDE_TEMPERATURE]);

  datalist.GetAverageValue ((int) COLD_TIP_1_NARROW_TEMPERATURE, startindex, stopindex, sensor);
  mopipfile.Compute (ColdTipNarrowTemperature1, sensor, summarydata[SUMMARY_COLD_TIP_1_NARROW_TEMPERATURE]);
}
