/********** EarthviewTrack.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   07/99   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_EARTHVIEW_TRACK_

  #define _MOPITT_L1_EARTHVIEW_TRACK_

  #include "EarthviewStare.h"
  #include "MOPIPFile.h"
  #include "EngineeringCollection.h"
  #include "SwathData.h"

  class earthview_track {
    private :
      int              laststare;
      int              stareids[SCIENCE_STARES];
      earthview_stare* stares [SCIENCE_STARES];

    protected :

    public :
      earthview_track ();
      ~earthview_track ();

      void             AddStare        (earthview_stare*);
      bool             DoesStareBelong (earthview_stare*) const;
      void             FillSwath       (mopip_file const&, engineering_collection&, swath_data*);
      earthview_stare* GetStare        (int stareindex) const 
                                        {return ((stareindex < 0 || stareindex >= SCIENCE_STARES) ? NULL :
                                                stares [stareindex]);}
      bool             IsEmpty         () const {return (laststare == 0);}
      bool             IsSingleStare   () const {return (laststare == 1);}
      void             ReInitialize    (earthview_stare*);
      int              GetStareID      (int stareindex) {return stareids[stareindex];}
  };

#endif
