/********** EarthviewTrack.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   07/99   Tom Lauren
   03/01   Ziskin - added packet position
   10/01   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "EarthviewTrack.h"

earthview_track :: earthview_track ()
{
  // set last stare number
  laststare = 0;

  // nullify all the pointers
  for (int i = 0; i < SCIENCE_STARES; i++)
    {
      stares[i] = NULL;
      stareids[i] = 0;
    }
}


earthview_track :: ~earthview_track ()
{
  for (int i = 0; i < SCIENCE_STARES; i++)
    delete stares[i];
}


void earthview_track :: AddStare (earthview_stare* earthstare)
{
  // get the stare number
  int starenumber = earthstare->GetStareNumber ();
  if (stares [starenumber - 1] == NULL)
    stares [starenumber - 1] = earthstare;

  stareids[starenumber - 1] = earthstare->GetStareID ();

  // reset the last stare number to this stare
  laststare = starenumber;
}


bool earthview_track :: DoesStareBelong (earthview_stare* earthstare) const
{
  bool doesbelong = false;

  // if there are not stares in the track, it belongs
  if (IsEmpty ())
    doesbelong = true;

  // if this stare is not for position 1 and the time gap between stares is within the tolerance
  else {
    int starenumber = earthstare->GetStareNumber ();
    if (starenumber != 1 &&
        (int) (0.5 + (((earthstare->GetTime ()).GetTAI () - (stares [laststare - 1]->GetTime ()).GetTAI ()) * 1000.0)) <
        ((STARE_MSECS_GAP * (starenumber - laststare)) + STARE_MSECS_GAP_EPSILON))
      doesbelong = true;
  }

  return doesbelong;
}


void earthview_track :: FillSwath (mopip_file const& mopipfile, engineering_collection& engineeringcollection, 
                                   swath_data* swathdata)
{

  // transfer the time and signal info from the track stares to the swath
  double staresignals [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET];
  int lastcellstate[SWATH_CHANNELS];
  earthview_stare* earthstare = NULL;
  for ( int ch = 0; ch < SWATH_CHANNELS; ch++ )
    for ( int px = 0; px < SWATH_PIXELS; px++ )
      for ( int ss = 0; ss < SWATH_SAWTOOTH_SET; ss++ )
	staresignals[ch][px][ss] = SWATH_MISSING_INT;

  for (int stareindex = 0; stareindex < SCIENCE_STARES; stareindex++)
    if ((earthstare = GetStare (stareindex)) != NULL) {
      swathdata->AddTime (stareindex, earthstare->GetTime ());
      earthstare->GetLastcellState (lastcellstate);
      swathdata->AddLastcellState (stareindex, lastcellstate);
      earthstare->GetSignals (staresignals);
      swathdata->AddSignals (stareindex, staresignals);
      swathdata->CollectPacketPositions (stareindex, GetStareID(stareindex));
    }

  // geolocate the track
  swathdata->GeoLocate (mopipfile);

  // retrieve the engineering data for this track
  swathdata->CollectEngineering (engineeringcollection, mopipfile);
}


void earthview_track :: ReInitialize (earthview_stare* earthstare)
{
  // set last stare number
  laststare = 0;

  // nullify all the pointers
  for (int i = 0; i < SCIENCE_STARES; i++) {
    delete stares[i];
    stares[i] = NULL;
  }

  // add the stare
  AddStare (earthstare);
}
