/********** EarthviewStare.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   03/01   Ziskin
   10/01   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_EARTHVIEW_STARE_

  #define _MOPITT_L1_EARTHVIEW_STARE_

  #include "ScienceTrain.h"
  #include "MOPITTTime.h"
  #include "SwathData.h"

  class earthview_stare {
    private :
      int            count;
      int            starenumber;
      mopitt_time    staretime;
      science_train* trains [SCIENCE_TRAINS];
      int            packetposition;

      void GetLMCTrainSignals (int, int, int, science_train*, 
                               double [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const;
      void GetLMCPMCTrainSignals (int, int, int, science_train*,
                                  double [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const;

    protected :

    public :
      earthview_stare ();
      earthview_stare (science_train*);
      ~earthview_stare ();

      void               AddTrain          (science_train*);
      bool               DoesTrainBelong   (science_train* sciencetrain) const 
                                              {return (IsEmpty () || staretime == sciencetrain->GetTime ());}
      void               GetSignals        (double [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const;
      int                GetStareNumber    () const {return starenumber;}
      mopitt_time const& GetTime           () const {return staretime;}
      bool               IsEmpty           () const {return (count == 0);}
      void               PruneTrains       () ;
      int                GetStareID        () {return packetposition;}
      void               GetLastcellState  ( int [SWATH_CHANNELS] );
      void               GetLastcellState  (int, int, science_train*, int [SWATH_CHANNELS] );
  };

#endif
