/********** EarthviewStare.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   10/01   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "EarthviewStare.h"
 
earthview_stare :: earthview_stare ()
                 : staretime ()
{
  count = 0;
  starenumber = 0; 
  for (int i = 0; i < SCIENCE_TRAINS; i++)
    trains[i] = NULL;
}


earthview_stare :: earthview_stare (science_train* sciencetrain)
{
  count = 0;
  starenumber = 0;  
  for (int i = 0; i < SCIENCE_TRAINS; i++)
    trains[i] = NULL;
  AddTrain (sciencetrain);
}


earthview_stare :: ~earthview_stare ()
{
  for (int i = 0; i < SCIENCE_TRAINS; i++)
    delete trains[i];
}


void earthview_stare :: GetLastcellState  (int lmclastcell[SWATH_CHANNELS] )
{

  // set lastcellstate to missing
  for (int channel = 0; channel < SWATH_CHANNELS; channel++)
    lmclastcell [channel] = SWATH_MISSING_VALUE;

  // get the lastcellstate from the trains
  GetLastcellState  (0, 1, trains [0], lmclastcell );
  GetLastcellState  (2, 3, trains [1], lmclastcell );
  GetLastcellState  (4, 5, trains [2], lmclastcell );
  GetLastcellState  (6, 7, trains [3], lmclastcell);

}

void earthview_stare :: GetLastcellState  (int channelIindex, int channelIIindex, science_train* sciencetrain, 
                                           int lmclastcell[SWATH_CHANNELS] )  
{
  // if the train is valid
  if (sciencetrain != NULL) {

    // get the cell states and store them in the lastcells container
    int lastcell;
    sciencetrain->GetLastcellState (CHANNEL_I,  lastcell); 
    lmclastcell [channelIindex] = lastcell ;

    sciencetrain->GetLastcellState (CHANNEL_II,  lastcell);
    lmclastcell [channelIIindex] = lastcell;
  }
}


void earthview_stare :: GetLMCTrainSignals (int trainnumber, int channelIindex, int channelIIindex, 
                                            science_train* sciencetrain,  
                                            double staresignals [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET])
                        const
{
  int pixel, sawtooth;

  // if the train is valid
  if (sciencetrain != NULL) {

    // compute the signals and store them in the stare signals container
    bool isvalid [SWATH_PIXELS];
    double lmcsignals [SWATH_PIXELS] [SWATH_SAWTOOTH_SET];
    sciencetrain->GetSignal (CHANNEL_I, (double*) lmcsignals, isvalid);
    for (pixel = 0; pixel < SWATH_PIXELS; pixel++)
      if (isvalid [pixel]) {
	for ( sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIindex][pixel][sawtooth] = lmcsignals [pixel][sawtooth];
      }
      else {
	for ( sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIindex][pixel][sawtooth] = SWATH_MISSING_VALUE;
      }
     
    sciencetrain->GetSignal (CHANNEL_II, (double*) lmcsignals, isvalid);
    for (pixel = 0; pixel < SWATH_PIXELS; pixel++)
      if (isvalid [pixel]) {
	for ( sawtooth  = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIIindex][pixel][sawtooth] = lmcsignals [pixel][sawtooth];
      }
      else {
	for ( sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIIindex][pixel][sawtooth] = SWATH_MISSING_VALUE;
      }
  }
}


void earthview_stare :: GetLMCPMCTrainSignals (int trainnumber, int channelIindex, int channelIIindex,
                                               science_train* sciencetrain,
                                               double staresignals [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET])
                        const
{
  int pixel, sawtooth;

  // if the train is valid
  if (sciencetrain != NULL) {

    // compute the signals
    bool isvalid [SWATH_PIXELS];
    double pmcsignals [SWATH_PIXELS] [PMC_SIGNAL_TERMS];
    sciencetrain->GetSignal (CHANNEL_I, (double*) pmcsignals, isvalid);
    for (pixel = 0; pixel < SWATH_PIXELS; pixel++)
      if (isvalid [pixel]) {
        staresignals [channelIindex][pixel][0] = pmcsignals [pixel][PMC_SIGNAL_AVERAGE_AVERAGE];
        staresignals [channelIindex][pixel][1] = pmcsignals [pixel][PMC_SIGNAL_AVERAGE_VARIANCE];
        staresignals [channelIindex][pixel][2] = pmcsignals [pixel][PMC_SIGNAL_DIFFERENCE_AVERAGE];
        staresignals [channelIindex][pixel][3] = pmcsignals [pixel][PMC_SIGNAL_DIFFERENCE_VARIANCE];
	for ( sawtooth = 4; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIindex][pixel][sawtooth] = SWATH_MISSING_VALUE;
      }
      else {
	for ( sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIindex][pixel][sawtooth] = SWATH_MISSING_VALUE;
      }

    double lmcsignals [SWATH_PIXELS] [SWATH_SAWTOOTH_SET];
    sciencetrain->GetSignal (CHANNEL_II, (double*) lmcsignals, isvalid);
    for (pixel = 0; pixel < SWATH_PIXELS; pixel++)
      if (isvalid [pixel]) {
	for ( sawtooth  = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIIindex][pixel][sawtooth] = lmcsignals [pixel][sawtooth];
      }
      else {
	for ( sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++ ) 
          staresignals [channelIIindex][pixel][sawtooth] = SWATH_MISSING_VALUE;
      }
  }
}


void earthview_stare :: AddTrain (science_train* sciencetrain)
{
  // add the pointer to the array
  trains[sciencetrain->GetID () - 1] = sciencetrain;

  // if this is the first one, set the time
  if (IsEmpty ())
    staretime = sciencetrain->GetTime ();

  packetposition = sciencetrain->GetPacketPosition();

   // increment the train counter
  count++;
}


void earthview_stare :: GetSignals (double staresignals [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const
{
  // set signals to missing
  for (int channel = 0; channel < SWATH_CHANNELS; channel++)
    for (int pixel = 0; pixel < SWATH_PIXELS; pixel++)
      for (int sawtooth = 0; sawtooth < SWATH_SAWTOOTH_SET; sawtooth++)
        staresignals [channel] [pixel] [sawtooth] = SWATH_MISSING_VALUE;

  // get the signals from the trains
  GetLMCTrainSignals    (1, 0, 1, trains [0], staresignals);
  GetLMCPMCTrainSignals (2, 2, 3, trains [1], staresignals);
  GetLMCTrainSignals    (3, 4, 5, trains [2], staresignals);
  GetLMCPMCTrainSignals (4, 6, 7, trains [3], staresignals);
}


void earthview_stare :: PruneTrains ()
{
  // compare all non-NULL trains and get a consensus stare number
  science_train* trainptr = NULL;
  int trainindex = 0;
  while (trainptr == NULL && trainindex < SCIENCE_TRAINS) {
    trainptr = trains[trainindex];
    trainindex++;
  }
  if (trainptr != NULL)
    starenumber = trainptr->GetStareNumber ();

  // prune off all trains that do not have the consensus stare number
  for (int i = 0; i < SCIENCE_TRAINS; i++)
    if (trains[i] != NULL)
      if (trains[i]->GetStareNumber () != starenumber) {
        delete trains[i];
        trains[i] = NULL;
      }
}
