/********** EarthviewCollections.h ************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   06/99   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_EARTHVIEW_COLLECTIONS_

  #define _MOPITT_L1_EARTHVIEW_COLLECTIONS_

  #include "EarthviewStare.h"
  #include "EarthviewTrack.h"
  #include "ProcessorParameters.h"
  #include "MOPESFile.h"
  #include "EngineeringCollection.h"
  #include "MOPIPFile.h"
  #include "SwathList.h"
  #include "ScienceTrain.h"

  class earthview_collections {
    private :
      earthview_stare*            currentstare;
      earthview_track             currenttrack;
      processor_parameters const& processorparameters;
      engineering_collection&     engineeringcollection;
      mopip_file const&           mopipfile;
      mopes_file                  mopesfile;
      swath_list&                 swaths;

    protected :

    public :
      earthview_collections (processor_parameters const&, engineering_collection&, mopip_file const&, swath_list&);
      ~earthview_collections ();

      void AddTrain (science_train*);
  };

#endif
