/********** EarthviewCollections.C ************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   06/99  Tom Lauren

 $Log$

\**********************************************************************************************************************/

#include "EarthviewCollections.h"

earthview_collections :: earthview_collections(processor_parameters const& parameters,engineering_collection& engineering,
					       mopip_file const& mopip, swath_list& swath)
                       : currenttrack (),
                         processorparameters (parameters),
                         engineeringcollection (engineering),
                         mopipfile (mopip),
                         mopesfile (mopip),
                         swaths (swath)
{
  currentstare = new earthview_stare ();
}


earthview_collections :: ~earthview_collections ()
{
  // if there's data in the current stare or current track
  if (! currentstare->IsEmpty () || ! currenttrack.IsEmpty ()) {

    // if the current stare is not empty 
    if (! currentstare->IsEmpty ()) {

      // do a final inspection of the stare (prune out the trains that don't belong)
      currentstare->PruneTrains ();

      // if the current stare belongs with the current track, add it
      if (currenttrack.DoesStareBelong (currentstare))
        currenttrack.AddStare (currentstare);
      else {
	
	// the normal situation of there being more than one stare in the track
	if (!currenttrack.IsSingleStare()) {

          // make a new swath data container; fill it; add it to the list; reinitialize track with stare
          swath_data* swathdata = new swath_data (swaths.GetCount ());
          currenttrack.FillSwath (mopipfile, engineeringcollection, swathdata);
          bool invalidate [SUMMARY_CHANNELS];
          mopesfile.Update (swathdata->GetStartTime (), swathdata->GetStopTime (), mopipfile, engineeringcollection, 
                            invalidate);
          swathdata->Invalidate (invalidate);
          swaths.AddSwath (swathdata);
	}
          
	currenttrack.ReInitialize (currentstare);
	
      }
    }

    if (!currenttrack.IsSingleStare()) {
	
      // make a new swath data container; fill it; add it to the list; reinitialize track with stare
      swath_data* swathdata = new swath_data (swaths.GetCount ());
      currenttrack.FillSwath (mopipfile, engineeringcollection, swathdata);
      bool invalidate [SUMMARY_CHANNELS];
      mopesfile.Update (swathdata->GetStartTime (), swathdata->GetStopTime (), mopipfile, engineeringcollection, 
                        invalidate);
      swathdata->Invalidate (invalidate);
      swaths.AddSwath (swathdata);
    }
  }
}


void earthview_collections :: AddTrain (science_train* sciencetrain)
{
  // if the train time is not within the processing time range, delete it, else add it
  mopitt_time traintime = sciencetrain->GetTime ();
  if (traintime < processorparameters.GetStartTime () || traintime > processorparameters.GetStopTime ())
    delete sciencetrain;
  else {

    // if the input train belongs with the current stare, send it
    if (currentstare->DoesTrainBelong (sciencetrain))
      currentstare->AddTrain (sciencetrain);
    else {

      // do a final inspection of the stare (prune out the trains that don't belong)
      currentstare->PruneTrains ();

      // if the current stare belongs with the current track, send it
      if (currenttrack.DoesStareBelong (currentstare))
        currenttrack.AddStare (currentstare);
      else {
	
	if (!currenttrack.IsSingleStare()) {

	  // make a new swath data container
	  swath_data* swathdata = new swath_data (swaths.GetCount ());

	  // fill the swath with data from the current track
	  currenttrack.FillSwath (mopipfile, engineeringcollection, swathdata);

	  // update the engineering summary
	  bool invalidate [SUMMARY_CHANNELS];
	  mopesfile.Update (swathdata->GetStartTime (), swathdata->GetStopTime (), mopipfile, engineeringcollection,
			    invalidate);
          swathdata->Invalidate (invalidate);

	  // add the swath data container to the swath list
	  swaths.AddSwath (swathdata);
	}

        // reinitialize the current track container with the current stare
        currenttrack.ReInitialize (currentstare);
      }

      // make a new current stare with the input train
      currentstare = new earthview_stare (sciencetrain);
    }
  }
}
