/********** L1Processor.C *********************************************************************************************\

 $Header$

 PURPOSE
   Main driver for L1 processor.

 INPUT ARGUMENTS
   None

 INPUT/OUTPUT ARGUMENTS
   None

 OUTPUT ARGUMENTS
   None

 RETURNS
   ON SUCCESS
     None
   ON FAILURE
     None

 ASSUMPTIONS ON ENTRY
   FILES
     The PGE PCF has staged all required files.
   OBJECTS
     None
   MISCELLANEOUS
     None

 ASSUMPTIONS ON EXIT
   FILES
     MOPCH, MOP01 and MOPQ1 files have been produced for this processing granule.
   OBJECTS
     None
   ERROR HANDLING
     Errors detected during PGE run have been written to the LogStatus file.
   MISCELLANEOUS
     PGE information has been written to the LogReport file.

 REVISION HISTORY

   07/12   Debbie Mao -- HDF-EOS5 and rm extra list

 $Log$

\**********************************************************************************************************************/
#include "Drivers.h"
#include "MOPQ1File.h"
#include "DiagnosticReporter.h"
#include "GlobalMetadata.h"

// make the level 1 metadata container globally accessible
global_metadata globalmetadata;

// make the diagnostic reporter globally accessible
diagnostic_reporter diagnosticreporter;

int main ()
{
  void MemoryError ();

  // install a memory allocation error function
  set_new_handler (MemoryError);

  // read the diagnostic thresholds from the PCF
  diagnosticreporter.ReadThresholds ();

  // have the diagnostic reporter use the mopq1 file for output
  mopq1_file mopq1file;
  diagnosticreporter.Open (mopq1file.GetFileLogical ());

  // initialize the swath list
  swath_list swathlist;

  // initialize the processor parameters
  processor_parameters processorparameters;

  // call the telemetry ingestor process driver
  IngestTelemetry (swathlist, processorparameters);

  // call the radiance calibrator process driver
  CalibrateRadiances (swathlist, processorparameters);

  // average noises by channel, pixel and shift 3D/7D by pixel
  PostProcInL1 ();

  // close the diagnostics file
  diagnosticreporter.Close ();
}


void MemoryError ()
{
  diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_SYSTEM_MODULE, MEMORY_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
                               "Could not allocate memory");
}
