/********** CalibrateRadiances.C **************************************************************************************\
 PURPOSE
   Radiance calibration driver for L1 processor.   

 INPUT          None

 INPUT/OUTPUT   swath_list&   swathlist   The Earth-view swaths container.

 RETURNS
   ON SUCCESS
   ON FAILURE

 ASSUMPTIONS ON ENTRY
   FILES
      The MOPITT Internal Radiance file and Calibration History files are available and staged.
   OBJECTS
      None
   MISCELLANEOUS
      None

 ASSUMPTIONS ON EXIT
   FILES
      The MOP01 file has been created.

 REVISION HISTORY
   12/98   Charles Cavanaugh
   07/99   Tom Lauren
   10/12   Debbie Mao

\**********************************************************************************************************************/

#include "Drivers.h"
#include "MOPIRCollection.h"
#include "CalibrationHistories.h"
#include "MOP01File.h"
#include "SwathData.h"
#include "MOP01GlobalMetadata.h"
#include "DiagnosticReporter.h"

mop01_global_metadata mop01globalmetadata;

void CalibrateRadiances (swath_list& swathlist, processor_parameters processorparameters)
{
  // get the internal radiance values
  mopir_collection mopircollection;
  mopircollection.Read ( );

  // read the cal histories
  calibration_histories calhistories;
  calhistories.Read (mopircollection, processorparameters);

  // initialize the mop01 file
  mop01_file mop01file;
  hdf_swath_group tracksgroup = mop01file.GetTracksGroup ();

  // make sure the swath structure gets defined in mop01 (in case there are no swaths in the swath list)
  swath_data* swathdata = new swath_data;
  swathdata->Define (mop01file.GetFileID (), tracksgroup);
  delete swathdata;

  int isnoiseget = 0, isnoisewritten = 0;
  // while there are swaths in the list
  swath_data* swath;
  while ((swath = swathlist.GetSwath ()) != NULL) {

    // calibrate the swath
    swath->Calibrate (calhistories, processorparameters);

    // get noise data
    swath->GetNoise (calhistories, isnoiseget);

    // write the calibrated swath
    swath->Write (tracksgroup, isnoisewritten);

    // delete the object
    delete swath;
  }

  mop01globalmetadata.SetEventDesc ("Normal granule");

}
