/********** DiagnosticReporter.h **************************************************************************************\

 $Header$

 REVISION HISTORY
   09/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   10/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_DIAGNOSTIC_REPORTER_

  #define _MOPITT_L1_DIAGNOSTIC_REPORTER_

  #include "PGS_PC.h"
  #include <string>
  #include <iostream>

  using namespace std;

  int const MEMORY_ERROR = 900;

  enum diagnostics_error_code { DIAGNOSTICS_WARNING = -1, DIAGNOSTICS_ERROR,   
                                DIAGNOSTICS_STATIC,  DIAGNOSTICS_TERSE, 
                                DIAGNOSTICS_VERBOSE };

  enum diagnostics_module_code { DIAGNOSTICS_CALIBRATIONS_MODULE, DIAGNOSTICS_EARTHVIEWS_MODULE,
                                 DIAGNOSTICS_ENGINEERING_MODULE,  DIAGNOSTICS_EXTRASTARE_MODULE,
                                 DIAGNOSTICS_FILE_MODULE,         DIAGNOSTICS_HDF_MODULE,
                                 DIAGNOSTICS_L0_MODULE,           DIAGNOSTICS_METADATA_MODULE,
                                 DIAGNOSTICS_MOP01_MODULE,        DIAGNOSTICS_MOPCH_MODULE,
                                 DIAGNOSTICS_MOPES_MODULE,        DIAGNOSTICS_MOPIP_MODULE,
                                 DIAGNOSTICS_MOPIR_MODULE,        DIAGNOSTICS_MOPQ1_MODULE,
                                 DIAGNOSTICS_PARAMETERS_MODULE,   DIAGNOSTICS_SCIENCE_MODULE,
                                 DIAGNOSTICS_SWATH_MODULE,        DIAGNOSTICS_SYSTEM_MODULE,
                                 DIAGNOSTICS_TABLE_MODULE,        DIAGNOSTICS_TIME_MODULE };

  class diagnostic_reporter {
    private :
      static int const                         MODULE_CODE_COUNT = 20;
      static enum diagnostics_error_code const DEFAULT_THRESHOLD;
      static PGSt_PC_Logical const             FILE_THRESHOLD_LOGICALS [MODULE_CODE_COUNT];
      static PGSt_PC_Logical const             SCREEN_THRESHOLD_LOGICALS [MODULE_CODE_COUNT];

      bool                        isabnormal;
      bool                        isopen;
      PGSt_IO_Gen_FileHandle*     handle;
      enum diagnostics_error_code filethresholds [MODULE_CODE_COUNT];
      enum diagnostics_error_code screenthresholds [MODULE_CODE_COUNT];

      string GetErrorCodeString (enum diagnostics_error_code errorcode) const
        { if      (errorcode == DIAGNOSTICS_WARNING) return "W"; 
          else if (errorcode == DIAGNOSTICS_ERROR)   return "E";
          else if (errorcode == DIAGNOSTICS_STATIC)  return "1";
          else if (errorcode == DIAGNOSTICS_TERSE)   return "2";
          else                                       return "3"; }

      string GetModuleCodeString (enum diagnostics_module_code modulecode) const
        { if      (modulecode == DIAGNOSTICS_CALIBRATIONS_MODULE) return "Calibr";
          else if (modulecode == DIAGNOSTICS_EARTHVIEWS_MODULE  ) return "Earthv";
          else if (modulecode == DIAGNOSTICS_ENGINEERING_MODULE ) return "Engine";
          else if (modulecode == DIAGNOSTICS_EXTRASTARE_MODULE  ) return "Extras";
          else if (modulecode == DIAGNOSTICS_FILE_MODULE        ) return "File__";
          else if (modulecode == DIAGNOSTICS_HDF_MODULE         ) return "Hdf___";
          else if (modulecode == DIAGNOSTICS_L0_MODULE          ) return "L0____";
          else if (modulecode == DIAGNOSTICS_METADATA_MODULE    ) return "Metada";
          else if (modulecode == DIAGNOSTICS_MOP01_MODULE       ) return "Mop01_";
          else if (modulecode == DIAGNOSTICS_MOPCH_MODULE       ) return "Mopch_";
          else if (modulecode == DIAGNOSTICS_MOPES_MODULE       ) return "Mopes_";
          else if (modulecode == DIAGNOSTICS_MOPIP_MODULE       ) return "Mopip_";
          else if (modulecode == DIAGNOSTICS_MOPIR_MODULE       ) return "Mopir_";
          else if (modulecode == DIAGNOSTICS_MOPQ1_MODULE       ) return "Mopq1_";
          else if (modulecode == DIAGNOSTICS_PARAMETERS_MODULE  ) return "Parame";
          else if (modulecode == DIAGNOSTICS_SCIENCE_MODULE     ) return "Scienc";
          else if (modulecode == DIAGNOSTICS_SWATH_MODULE       ) return "Swath_";
          else if (modulecode == DIAGNOSTICS_SYSTEM_MODULE      ) return "System";
          else if (modulecode == DIAGNOSTICS_TABLE_MODULE       ) return "Table_";
          else if (modulecode == DIAGNOSTICS_TIME_MODULE        ) return "Time__";
          else                                                    return "??????"; }

      void AddHeaders     (enum diagnostics_error_code, enum diagnostics_module_code, int, string&) const;
      void AddIndeces     (int, int, int, int, int, int, int, int, string&) const;
      void AddIndex       (string const&, int, int, string&) const;
      void Exit           () const;
      void Initialize     ();
      void ReadLogical    (PGSt_PC_Logical, enum diagnostics_error_code&) const;
      void WriteEntry     (enum diagnostics_error_code, enum diagnostics_error_code, enum diagnostics_error_code, 
                           string const&) const;

    protected :

    public :
      diagnostic_reporter ();
     ~diagnostic_reporter ();

     void AddEntry       (enum diagnostics_error_code, enum diagnostics_module_code, int, int, int, int, int, int, 
                          int, int, int, string const&);
     void Close          ();
     void Open           (PGSt_PC_Logical);
     void ReadThresholds ();
  };

#endif
