/********** CalibrationTrainHistory.h *********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   04/02   Debbie Mao
   05/02   Debbie Mao
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_TRAIN_HISTORY_

  #define _MOPITT_L1_CALIBRATION_TRAIN_HISTORY_

  #include "MOPIRCollection.h"
  #include "CalibrationConstants.h"
  #include "CalibrationChannelHistory.h"
  #include "ProcessorParameters.h"

  class calibration_train_history {
    private :

    protected :
      int train;
      calibration_channel_history* channelI;
      calibration_channel_history* channelII;

    public :
      calibration_train_history (int);
      virtual ~calibration_train_history () = 0;

      bool GetHotBracketingTimes (mopitt_time const&, mopitt_time&, mopitt_time&);
      bool GetTrackData (mopitt_time const&, 
		float  [CALIBRATION_CHANNELS][CALIBRATION_PIXELS][CALIBRATION_STATES][CALIBRATION_TERMS],
		double [CALIBRATION_CHANNELS][CALIBRATION_PACKETPOSITION][CALIBRATION_PIXELS][PMC_SIGNAL_STATES]);
      void GetNoiseData (float [PMC_CHANNELS][CALIBRATION_PIXELS][POSITION_NOISE_STATES][CALIBRATION_PACKETPOSITION]);
      virtual void Read  (mopir_collection const&, processor_parameters const&) {;}
  };

#endif
