/********** CalibrationTrainHistory.C *********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationTrainHistory.h"

calibration_train_history :: calibration_train_history (int trainnumber)
{
  train = trainnumber;
  channelI = NULL;
  channelII = NULL;
}


calibration_train_history :: ~calibration_train_history ()
{
  ;
}


bool calibration_train_history :: GetHotBracketingTimes (mopitt_time const& tracktime, mopitt_time& pretime,
                                                         mopitt_time& posttime)
{
  bool isretrieved = true;

  if (channelII == NULL)
    isretrieved = false;
  else
    channelII->GetBracketingTimes (tracktime, pretime, posttime);
 
  return isretrieved;
}


bool calibration_train_history :: GetTrackData (mopitt_time const& tracktime, 
          float trackdata [CALIBRATION_CHANNELS] [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
	  double trackcoldcal [CALIBRATION_CHANNELS] [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES])
{
  bool isretrieved = true;

  if (channelI == NULL || channelII == NULL)
    isretrieved = false;
  else {
    channelI->GetTrackData  (tracktime, trackdata [((train * 2) - 2)], trackcoldcal [((train * 2) - 2)]);
    channelII->GetTrackData (tracktime, trackdata [((train * 2) - 1)], trackcoldcal [((train * 2) - 1)]);
  }
  return isretrieved;
}


void calibration_train_history :: GetNoiseData (
          float posnoise [PMC_CHANNELS] [CALIBRATION_PIXELS][POSITION_NOISE_STATES] [CALIBRATION_PACKETPOSITION])
{
  channelI->GetNoiseData  ( posnoise[((train - 2) / 2 )] );
}
