/********** CalibrationTrain4History.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   11/00   Charles Cavanaugh
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrainLMCPMCGroup.h"
#include "CalibrationTrain4History.h"
#include "CalibrationChannelLMCSolarHistory.h"
#include "CalibrationChannelPMCHistory.h"

calibration_train_4_history :: calibration_train_4_history ()
                             : calibration_train_history (4)
{
  channelI  = new calibration_channel_pmc_history (7);
  channelII = new calibration_channel_lmc_solar_history (8);
}


calibration_train_4_history :: ~calibration_train_4_history ()
{
  delete channelI;
  delete channelII;
}


void calibration_train_4_history :: Read (mopir_collection const& mopircollection, 
					  processor_parameters const& processorparameters  )
{
  science_train_group* traingroup = new science_train_lmcpmc_group (4);

  channelI->Read (MOPCH_PRE_GRANULE_TRAIN_4_WARM_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_4_COLD_FILELOGICAL, 
                  MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_4_WARM_FILELOGICAL,
                  MOPCH_POST_GRANULE_TRAIN_4_COLD_FILELOGICAL, WARM_DATA_TYPE, traingroup, mopircollection,
		  processorparameters);
  channelII->Read (MOPCH_PRE_GRANULE_TRAIN_4_HOT_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_4_COLD_FILELOGICAL, 
                   MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_4_HOT_FILELOGICAL,
                   MOPCH_POST_GRANULE_TRAIN_4_COLD_FILELOGICAL, HOT_DATA_TYPE, traingroup, mopircollection,
		   processorparameters);

  delete traingroup;
}
