/********** CalibrationTrain3History.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   11/00   Charles Cavanaugh
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrainLMCGroup.h"
#include "CalibrationTrain3History.h"
#include "CalibrationChannelLMCHistory.h"
#include "CalibrationChannelLMCSolarHistory.h"

calibration_train_3_history :: calibration_train_3_history ()
                             : calibration_train_history (3)
{
  channelI  = new calibration_channel_lmc_history (5);
  channelII = new calibration_channel_lmc_solar_history (6);
}


calibration_train_3_history :: ~calibration_train_3_history ()
{
  delete channelI;
  delete channelII;
}


void calibration_train_3_history :: Read (mopir_collection const& mopircollection,
					  processor_parameters const& processorparameters )
{
  science_train_group* traingroup = new science_train_lmc_group (3);

  channelI->Read (MOPCH_PRE_GRANULE_TRAIN_3_WARM_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_3_COLD_FILELOGICAL, 
                  MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_3_WARM_FILELOGICAL,
                  MOPCH_POST_GRANULE_TRAIN_3_COLD_FILELOGICAL, WARM_DATA_TYPE, traingroup, mopircollection,
		  processorparameters);
  channelII->Read (MOPCH_PRE_GRANULE_TRAIN_3_HOT_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_3_COLD_FILELOGICAL, 
                   MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_3_HOT_FILELOGICAL,
                   MOPCH_POST_GRANULE_TRAIN_3_COLD_FILELOGICAL, HOT_DATA_TYPE, traingroup, mopircollection,
		   processorparameters);

  delete traingroup;
}
