/********** CalibrationTrain1History.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   11/00   Charles Cavanaugh
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrainLMCGroup.h"
#include "CalibrationTrain1History.h"
#include "CalibrationChannelLMCHistory.h"
#include "CalibrationChannelLMCSolarHistory.h"

calibration_train_1_history :: calibration_train_1_history ()
                             : calibration_train_history (1)
{
  channelI  = new calibration_channel_lmc_history (1);
  channelII = new calibration_channel_lmc_solar_history (2);
}


calibration_train_1_history :: ~calibration_train_1_history ()
{
  delete channelI;
  delete channelII;
}


void calibration_train_1_history :: Read (mopir_collection const& mopircollection,
					   processor_parameters const& processorparameters )
{
  science_train_group* traingroup = new science_train_lmc_group (1);

  channelI->Read (MOPCH_PRE_GRANULE_TRAIN_1_WARM_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_1_COLD_FILELOGICAL, 
                  MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_1_WARM_FILELOGICAL,
                  MOPCH_POST_GRANULE_TRAIN_1_COLD_FILELOGICAL, WARM_DATA_TYPE, traingroup, mopircollection,
		  processorparameters);
  channelII->Read (MOPCH_PRE_GRANULE_TRAIN_1_HOT_FILELOGICAL, MOPCH_PRE_GRANULE_TRAIN_1_COLD_FILELOGICAL, 
                   MOPCH_CURRENT_GRANULE_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_1_HOT_FILELOGICAL,
                   MOPCH_POST_GRANULE_TRAIN_1_COLD_FILELOGICAL, HOT_DATA_TYPE, traingroup, mopircollection,
		   processorparameters);

  delete traingroup;
}
