/********** CalibrationRecordList.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "CalibrationRecordList.h"

calibration_record_list :: calibration_record_list ()
                         : records ()
{
  ResetNext ();
}


calibration_record_list :: ~calibration_record_list ()
{
  Empty ();
}


void calibration_record_list :: AddRecord (calibration_channel_record* channelrecord)
{
  records.push_back (channelrecord);
}


void calibration_record_list :: Empty ()
{
  calibration_channel_record* channelrecord;

  while (! records.empty ()) {
    channelrecord = records.front ();
    delete channelrecord;
    records.pop_front ();
  }
}


calibration_channel_record* calibration_record_list :: GetNext ()
{
  calibration_channel_record* nextrecord = NULL;

  deque <calibration_channel_record*> :: const_iterator iter = records.begin () + next;
  if (iter != records.end ()) {
    nextrecord = (*iter);
    next++;
  }

  return nextrecord;
}


bool calibration_record_list :: GetNext (calibration_channel_record** channelrecord)
{
  bool isfound = false;

  deque <calibration_channel_record*> :: const_iterator iter = records.begin () + next;
  if (iter != records.end ()) {
    *channelrecord = (calibration_channel_record*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}


void calibration_record_list :: ResetNext ()
{
  next = 0;
}
