/********** CalibrationNoiseRecordList.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationNoiseRecordList.h"

calibration_noise_record_list :: calibration_noise_record_list ()
                               : records ()
{
  ResetNext ();
}


calibration_noise_record_list :: ~calibration_noise_record_list ()
{
  Empty ();
}


void calibration_noise_record_list :: AddRecord (calibration_channel_noise_record* channelnoiserecord)
{
  records.push_back (channelnoiserecord);
}


void calibration_noise_record_list :: Empty ()
{
  calibration_channel_noise_record* channelnoiserecord;

  while (! records.empty ()) {
    channelnoiserecord = records.front ();
    delete channelnoiserecord;
    records.pop_front ();
  }
}


calibration_channel_noise_record* calibration_noise_record_list :: GetNext ()
{
  calibration_channel_noise_record* nextrecord = NULL;

  deque <calibration_channel_noise_record*> :: const_iterator iter = records.begin () + next;
  if (iter != records.end ()) {
    nextrecord = (*iter);
    next++;
  }

  return nextrecord;
}


bool calibration_noise_record_list :: GetNext (calibration_channel_noise_record** channelnoiserecord)
{
  bool isfound = false;

  deque <calibration_channel_noise_record*> :: const_iterator iter = records.begin () + next;
  if (iter != records.end ()) {
    *channelnoiserecord = (calibration_channel_noise_record*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}


void calibration_noise_record_list :: ResetNext ()
{
  next = 0;
}

