/********** CalibrationLMCPMCEvent.h **********************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_LMCPMC_EVENT_

  #define _MOPITT_L1_CALIBRATION_LMCPMC_EVENT_

  #include "CalibrationEvent.h"
  #include "ScienceCalibrationLMCPMCRecord.h"

  class calibration_lmcpmc_event : public calibration_event {
    private :
      void ComputePMCSignals    (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
			         double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
				 double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] );
      void GetPMCEventMeans     (double [SCIENCE_PIXELS] [PMC_STROKES], double [SCIENCE_PIXELS] [PMC_STROKES],
                                 double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES],
			         double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES], 
				 double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES],
				 double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES], bool [SCIENCE_PIXELS]);
      void GetPMCEventVariances (double const [SCIENCE_PIXELS] [PMC_STROKES],double const [SCIENCE_PIXELS] [PMC_STROKES], 
                                 double [SCIENCE_PIXELS] [PMC_STROKES], double [SCIENCE_PIXELS] [PMC_STROKES],
				 double const [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES], 
				 double const [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES],
				 double  [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES],
				 double  [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_STROKES] );
      bool MakeRecord           (science_calibration_record*);

    protected :

    public :
      calibration_lmcpmc_event (int, engineering_collection&, mopip_file const&);
      ~calibration_lmcpmc_event ();

      bool AddTrain (science_train*, science_train_group*);
      bool Write    (science_train_group*);
    };

#endif
