/********** CalibrationLMCEvent.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   02/02   Debbie Mao
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationLMCEvent.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

calibration_lmc_event :: calibration_lmc_event (int train, engineering_collection& engineering, mopip_file const& mopip)
                       : calibration_event (train, engineering, mopip)
{
  ;
}


calibration_lmc_event :: ~calibration_lmc_event ()
{
  ;
}


bool calibration_lmc_event :: MakeRecord (science_calibration_record* record)
{
  bool issignalszero = false;

  // compute the signals
  double signalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  double signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  double sectorsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  double sectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  ComputeLMCSignals (CHANNEL_I,  signalsI, sectorsignalsI);
  ComputeLMCSignals (CHANNEL_II, signalsII, sectorsignalsII);


 // ADDED BY ZISKIN FOR SHADOW FLAG DIAGNOSTICS
  //char shagMsg[200];
  //(void) sprintf (shagMsg,  "SHADOW Signal Event for train %3.6f", signalsII[0][0]);
  //string shadMsg = shagMsg;
  //diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_CALIBRATIONS_MODULE, 11, 0, 0, 0, 0,
  //			       train, 0, 0, 0, shadMsg);



  
  // set the record
  record->SetRecordData (trains.GetCount (), 
                        engineeringcollection.GetEventTemperature (train, starttime, stoptime, mopipfile), 
                        starttime.GetDay (), starttime.GetMsecs (), stoptime.GetMsecs (), 
                        GetShadowStatus (starttime.GetDay (), starttime.GetMsecs (), stoptime.GetMsecs ()),
                        signalsI, signalsII, sectorsignalsI, sectorsignalsII);

  if ( ( signalsI  [0][0] ==  0.0 && signalsI  [0][1] == 0.0 ) ||
       ( signalsII [0][0] ==  0.0 && signalsII [0][1] == 0.0 ) )
    issignalszero = true;
  return issignalszero;
}


bool calibration_lmc_event :: AddTrain (science_train* sciencetrain, science_train_group* traingroup)
{
  bool isadded = true;

  if (DoesTrainBelong (sciencetrain))
    UpdateEvent (sciencetrain);
  else {
    isadded = Write (traingroup);
    ReInitializeEvent (sciencetrain);
  }

  return isadded;
}


bool calibration_lmc_event :: Write (science_train_group* traingroup)
{
  bool iswritten = false, issignalszero = false;;

  // process only if there are enough stares
  if (! HasEnoughStares ())
    WriteStareCountDiagnostic ();
  else {
    science_calibration_record* record = new science_calibration_lmc_record ();
    issignalszero = MakeRecord (record);
    if ( issignalszero != true )
      if ((iswritten = traingroup->AddRecord (GetTrainDataType (engineeringcollection, mopipfile), record))) {
	unsigned short starecount, dummyshort;
	float temperature;
	int dummy;
	record->GetHeaderInfo (starecount, temperature, dummy, dummy, dummy, dummyshort);
	WriteInfo (starecount, temperature);
      }
    delete record;
  }

  return iswritten;
}
