/********** CalibrationHistories.C ************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   04/02   Debbie Mao
   05/02   Debbie Mao
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationHistories.h"

calibration_histories :: calibration_histories ()
                       : train1 (),
                         train2 (),
                         train3 (),
                         train4 ()
{
  ;
}


calibration_histories :: ~calibration_histories ()
{
  ;
}


void calibration_histories :: GetHotBracketingTimes (mopitt_time const& tracktime, mopitt_time& prehot1, 
                                                     mopitt_time& prehot2, mopitt_time& prehot3, 
                                                     mopitt_time& prehot4, mopitt_time& posthot1,
                                                     mopitt_time& posthot2, mopitt_time& posthot3, 
                                                     mopitt_time& posthot4)
{
  train1.GetHotBracketingTimes (tracktime, prehot1, posthot1);
  train2.GetHotBracketingTimes (tracktime, prehot2, posthot2);
  train3.GetHotBracketingTimes (tracktime, prehot3, posthot3);
  train4.GetHotBracketingTimes (tracktime, prehot4, posthot4);
}


void calibration_histories :: GetTrackData (mopitt_time& tracktime, 
           float trackdata [CALIBRATION_CHANNELS] [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
	   double trackcoldcal [CALIBRATION_CHANNELS] [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES])
{
  train1.GetTrackData (tracktime, trackdata, trackcoldcal);
  train2.GetTrackData (tracktime, trackdata, trackcoldcal);
  train3.GetTrackData (tracktime, trackdata, trackcoldcal);
  train4.GetTrackData (tracktime, trackdata, trackcoldcal);
}


void calibration_histories :: Read (mopir_collection const& mopircollection, processor_parameters const& parameters)
{
  train1.Read (mopircollection, parameters);
  train2.Read (mopircollection, parameters);
  train3.Read (mopircollection, parameters);
  train4.Read (mopircollection, parameters);
}


void calibration_histories :: GetNoiseData (
	   float posnoise [PMC_CHANNELS] [CALIBRATION_PIXELS] [POSITION_NOISE_STATES] [CALIBRATION_PACKETPOSITION] )
{
  train2.GetNoiseData (posnoise);
  train4.GetNoiseData (posnoise);
}
