/********** CalibrationEvent.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   06/99   Tom Lauren
   11/99   Charles Cavanaugh
   02/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_EVENT_

  #define _MOPITT_L1_CALIBRATION_EVENT_

  #include "CalibrationConstants.h"
  #include "ScienceTrainList.h"
  #include "ScienceTrainGroup.h"
  #include "EngineeringCollection.h"
  #include "MOPIPFile.h"

  class calibration_event {
    private :
      static float const          CALIBRATION_EVENT_HOT_MINIMUM_TEMPERATURE;
      static float const          CALIBRATION_EVENT_WARM_MAXIMUM_TEMPERATURE;
      static unsigned short const CALIBRATION_EVENT_MINIMUM_TRAIN_COUNT;
      static unsigned short const CALIBRATION_EVENT_MAXIMUM_TRAIN_COUNT;
      static int const            CALIBRATION_EVENT_MSECS_GAP_TOLERANCE;
      static double const         SHADOWVECTOR_MINIMUM;
      static int const            STARECOUNT_WARNING;

      void GetLMCEventMeans       (enum science_channel_number, double [SCIENCE_PIXELS] [LMC_SECTORS],
                                   double [SCIENCE_PIXELS] [LMC_SECTORS], bool [SCIENCE_PIXELS]);
      void GetLMCEventVariances   (enum science_channel_number, double const [SCIENCE_PIXELS] [LMC_SECTORS],
                                   double const [SCIENCE_PIXELS] [LMC_SECTORS], double [SCIENCE_PIXELS] [LMC_SECTORS],
                                   double [SCIENCE_PIXELS] [LMC_SECTORS]);

      double Determ (double a, double b, double c, double d, double e, double f, double g, double h, double i) 
	{ return a * (e * i - f * h) - b * (d * i - f * g) + c * (d * h - e * g); }

    protected :
      int                     train;
      int                     mirrorposition;
      mopitt_time             starttime;
      mopitt_time             stoptime;
      science_train_list      trains;
      engineering_collection& engineeringcollection;
      mopip_file const&       mopipfile;

      void                         ComputeLMCSignals         (enum science_channel_number, 
                                                              double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
							      double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] );
      bool                         DoesTrainBelong           (science_train*) const;
      bool                         GetShadowStatus           (int, int, int) const;
      enum science_train_data_type GetTrainDataType          (engineering_collection&, mopip_file const&);
      bool                         HasEnoughStares           () const {return ((trains.GetCount () >= 
                                                                               CALIBRATION_EVENT_MINIMUM_TRAIN_COUNT));}
      void                         PolyRegressionFit         (double* const, double* const, int, double*);
      void                         ReInitializeEvent         (science_train*);
      void                         UpdateEvent               (science_train*);
      void                         WriteInfo                 (unsigned short, float) const;
      void                         WriteStareCountDiagnostic () const;

    public :
      calibration_event (int, engineering_collection&, mopip_file const&);
      virtual ~calibration_event () = 0;

      virtual bool AddTrain (science_train*, science_train_group*) {return false;}
      virtual bool Write    (science_train_group*) {return false;}
  };

#endif
