/********** CalibrationConstants.h ************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   06/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_CONSTANTS_

  #define _MOPITT_L1_CALIBRATION_CONSTANTS_

  #include "ScienceConstants.h"

  int   const CALIBRATION_CHANNELS       = SCIENCE_CHANNELS;
  int   const CALIBRATION_PIXELS         = SCIENCE_PIXELS;
  int   const CALIBRATION_PACKETPOSITION = SCIENCE_PACKETPOSITION;
  int   const CALIBRATION_STATES         = 6;
  int   const CALIBRATION_TERMS          = 8;
  float const CALIBRATION_MISSING_VALUE  = SCIENCE_MISSING_VALUE;
  int   const CALIBRATION_MISSING_INT    = (int) (SCIENCE_MISSING_VALUE + 0.5);
  int   const PMC_CHANNELS               = 2;
  int   const POSITION_NOISE_STATES      = 2;
  int   const WARM_EVENT_COUNT           = 200;

  enum calibration_state_offset { CALIBRATION_STATE_AVERAGE,  CALIBRATION_STATE_DIFFERENCE, 
				  CALIBRATION_STATE_A_SECTOR, CALIBRATION_STATE_B_SECTOR,
				  CALIBRATION_STATE_C_SECTOR, CALIBRATION_STATE_D_SECTOR   };

  enum calibration_term_offset { CALIBRATION_TERM_GAIN_MEAN,   CALIBRATION_TERM_OFFSET_MEAN,
                                 CALIBRATION_TERM_NOISE_MEAN,  CALIBRATION_TERM_RADIANCE_MEAN,
                                 CALIBRATION_TERM_GAIN_ERROR,  CALIBRATION_TERM_OFFSET_ERROR,
                                 CALIBRATION_TERM_NOISE_ERROR, CALIBRATION_TERM_RADIANCE_ERROR };

  enum position_noise_state_offset  { POSITION_NOISE_AVERAGE,  POSITION_NOISE_DIFFERENCE };

#endif
