/********** CalibrationCollections.h **********************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_COLLECTIONS_

  #define _MOPITT_L1_CALIBRATION_COLLECTIONS_

  #include "ProcessorParameters.h"
  #include "MOPCHWriteFile.h"
  #include "EngineeringCollection.h"
  #include "MOPIPFile.h"
  #include "CalibrationEvent.h"
  #include "ScienceTrain.h"
  #include "ScienceTrainGroup.h"

  class calibration_collections {
    private :
      static int const TIME_TERSE;

      processor_parameters const& processorparameters;
      calibration_event*          calibrationevent [SCIENCE_TRAINS];
      science_train_group*        traingroup [SCIENCE_TRAINS];

      bool Initialize     (engineering_collection&, mopip_file const&, mopch_write_file&);
      bool Finalize       ();
      void SetEventCounts (int, science_train_group*) const;

    protected :

    public :
      calibration_collections (processor_parameters const&, engineering_collection&, mopip_file const&, 
                               mopch_write_file&);
      ~calibration_collections ();

      bool AddTrain (science_train*);
  };

#endif
