/********** CalibrationChannelRecord.h ********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   04/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_CHANNEL_RECORD_

  #define _MOPITT_L1_CALIBRATION_CHANNEL_RECORD_

  #include "MOPITTTime.h"
  #include "CalibrationConstants.h"

  class calibration_channel_record {
    private :
      mopitt_time recordtime;
      float       recorddata [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS];
      double      coldcaldata [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES];

    protected :

    public :
      calibration_channel_record ();
      calibration_channel_record (mopitt_time const&);
      ~calibration_channel_record ();

      void               AddData     (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS] );
      void               AddGain     (int, enum calibration_state_offset, float, float);
      void               AddNoise    (int, enum calibration_state_offset, float, float);
      void               AddNoise    (enum calibration_state_offset, float, float);
      void               AddOffset   (int, enum calibration_state_offset, float, float);
      void               AddRadiance (int, enum calibration_state_offset, float, float);
      void               AddRadiance (enum calibration_state_offset, float, float);
      void               AddColdCals (double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES] );
      void               AddTime     (mopitt_time const&);
      void               GetData     (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS] );
      void               GetData     (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
				      double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES]);
      void               GetGain     (int, enum calibration_state_offset, float&, float&) const;
      void               GetNoise    (int, enum calibration_state_offset, float&, float&) const;
      void               GetOffset   (int, enum calibration_state_offset, float&, float&) const;
      void               GetRadiance (int, enum calibration_state_offset, float&, float&) const;
      void               GetColdCals (double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES] );
      mopitt_time const& GetTime     () const {return recordtime;}

  };

#endif
