/********** CalibrationChannelRecord.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationChannelRecord.h"
#include <memory.h>

calibration_channel_record :: calibration_channel_record ()
                            : recordtime ()
{
  for ( int pixel = 0; pixel < CALIBRATION_PIXELS; pixel ++ ) {
    for ( int state = 0; state < CALIBRATION_STATES; state ++ )
      for ( int term = 0; term < CALIBRATION_TERMS; term ++ )
	recorddata [pixel] [state] [term] = CALIBRATION_MISSING_VALUE;
    for ( int pos = 0; pos < CALIBRATION_PACKETPOSITION; pos++ ) 
      for ( int pmcstate = 0; pmcstate < PMC_SIGNAL_STATES; pmcstate++ )
	coldcaldata [pos] [pixel] [pmcstate] = CALIBRATION_MISSING_VALUE; 
  }
}


calibration_channel_record :: calibration_channel_record (mopitt_time const& newtime)
{
  for ( int pixel = 0; pixel < CALIBRATION_PIXELS; pixel ++ ) {
    for ( int state = 0; state < CALIBRATION_STATES; state ++ )
      for ( int term = 0; term < CALIBRATION_TERMS; term ++ )
	recorddata [pixel] [state] [term] = CALIBRATION_MISSING_VALUE;
    for ( int pos = 0; pos < CALIBRATION_PACKETPOSITION; pos++ ) 
      for ( int pmcstate = 0; pmcstate < PMC_SIGNAL_STATES; pmcstate++ )
	coldcaldata [pos] [pixel] [pmcstate] = CALIBRATION_MISSING_VALUE; 
  }
  AddTime (newtime);
}


calibration_channel_record :: ~calibration_channel_record ()
{
  ;
}


void calibration_channel_record :: AddData ( float trackdata [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS])
{
  (void) memcpy ((void*) recorddata, (const void*) trackdata, 
                 sizeof (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS]));
}


void calibration_channel_record :: AddGain (int pixel, enum calibration_state_offset state, float mean, float error)
{
  recorddata [pixel] [state] [CALIBRATION_TERM_GAIN_MEAN]  = mean;
  recorddata [pixel] [state] [CALIBRATION_TERM_GAIN_ERROR] = error;
}


void calibration_channel_record :: AddNoise (int pixel, enum calibration_state_offset state, float mean, float error)
{
  recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_MEAN]  = mean;
  recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_ERROR] = error;
}


void calibration_channel_record :: AddNoise (enum calibration_state_offset state, float mean, float error)
{
  for (int pixel = 0; pixel < CALIBRATION_PIXELS; pixel++) {
    recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_MEAN]  = mean;
    recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_ERROR] = error;
  }
}


void calibration_channel_record :: AddOffset (int pixel, enum calibration_state_offset state, float mean, float error)
{
  recorddata [pixel] [state] [CALIBRATION_TERM_OFFSET_MEAN]  = mean;
  recorddata [pixel] [state] [CALIBRATION_TERM_OFFSET_ERROR] = error;
}


void calibration_channel_record :: AddRadiance (int pixel, enum calibration_state_offset state, float mean, float error)
{
  recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_MEAN]  = mean;
  recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_ERROR] = error;
}


void calibration_channel_record :: AddRadiance (enum calibration_state_offset state, float mean, float error)
{
  for (int pixel = 0; pixel < CALIBRATION_PIXELS; pixel++) {
    recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_MEAN]  = mean;
    recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_ERROR] = error;
  }
}


void calibration_channel_record :: AddColdCals ( double coldsignals [CALIBRATION_PACKETPOSITION] 
								    [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES] )
{
  for ( int pos = 0; pos < CALIBRATION_PACKETPOSITION; pos++ )
    for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) 
      for ( int pmcstate = 0; pmcstate < PMC_SIGNAL_STATES; pmcstate++ )
	coldcaldata [pos] [pixel] [pmcstate] = coldsignals [pos] [pixel] [pmcstate]; 
}


void calibration_channel_record :: AddTime (mopitt_time const& newtime)
{
  recordtime = newtime;
}


void calibration_channel_record :: GetData ( float trackdata [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS])
{
  (void) memcpy ((void*) trackdata, (const void*) recorddata, 
                 sizeof (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS]));
}


void calibration_channel_record :: GetData ( float trackdata [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
			                     double trackcoldcal [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] 
					     [PMC_SIGNAL_STATES])
{
  (void) memcpy ((void*) trackdata, (const void*) recorddata, 
                 sizeof (float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS]));
  (void) memcpy ((void*) trackcoldcal, (const void*) coldcaldata, 
                 sizeof (double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES]));
}


void calibration_channel_record :: GetGain (int pixel, enum calibration_state_offset state, float& mean, float& error)
   const
{
  mean  = recorddata [pixel] [state] [CALIBRATION_TERM_GAIN_MEAN];
  error = recorddata [pixel] [state] [CALIBRATION_TERM_GAIN_ERROR];
}


void calibration_channel_record :: GetNoise (int pixel, enum calibration_state_offset state, float& mean, float& error)
   const
{
  mean  = recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_MEAN];
  error = recorddata [pixel] [state] [CALIBRATION_TERM_NOISE_ERROR];
}


void calibration_channel_record :: GetOffset (int pixel, enum calibration_state_offset state, float& mean, float& error)
   const
{
  mean  = recorddata [pixel] [state] [CALIBRATION_TERM_OFFSET_MEAN];
  error = recorddata [pixel] [state] [CALIBRATION_TERM_OFFSET_ERROR];
}


void calibration_channel_record :: GetRadiance (int pixel, enum calibration_state_offset state, float& mean, 
                                                float& error) const
{
  mean  = recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_MEAN];
  error = recorddata [pixel] [state] [CALIBRATION_TERM_RADIANCE_ERROR];
}


void calibration_channel_record :: GetColdCals ( double coldsignals [CALIBRATION_PACKETPOSITION]
								    [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES] )
{
  for ( int pos = 0; pos < CALIBRATION_PACKETPOSITION; pos++ )
    for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++)
      for ( int pmcstate = 0; pmcstate < PMC_SIGNAL_STATES; pmcstate++ )
	coldsignals [pos] [pixel] [pmcstate] = coldcaldata [pos] [pixel] [pmcstate];
}

